/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.fixedwidth;

import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;
import org.databene.commons.StringUtil;
import org.databene.commons.format.Alignment;
import org.databene.commons.format.PadFormat;

public class FixedWidthColumnDescriptor {
    private String name;
    private int width;
    private PadFormat format;

    public FixedWidthColumnDescriptor(int width, Alignment alignment) {
        this((String)null, width, alignment, ' ');
    }

    public FixedWidthColumnDescriptor(String name, int width, Alignment alignment) {
        this(name, width, alignment, ' ');
    }

    public FixedWidthColumnDescriptor(int width, Alignment alignment, char padChar) {
        this((String)null, width, alignment, padChar);
    }

    public FixedWidthColumnDescriptor(String name, int width, Alignment alignment, char padChar) {
        this(name, null, "", width, alignment, padChar);
    }

    public FixedWidthColumnDescriptor(Format format, int width, Alignment alignment, char padChar) {
        this(null, format, "", width, alignment, padChar);
    }

    public FixedWidthColumnDescriptor(String name, Format format, String nullString) {
        this(name, format, nullString, FixedWidthColumnDescriptor.formatWidth(format), Alignment.LEFT, ' ');
    }

    public FixedWidthColumnDescriptor(String name, Format format, String nullString, int width, Alignment alignment, char padChar) {
        this.name = name;
        this.width = width;
        this.format = new PadFormat(format, nullString, width, alignment, padChar);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getWidth() {
        return this.width;
    }

    public Format getFormat() {
        return this.format;
    }

    public String format(Object object) {
        try {
            return this.format.format(object);
        }
        catch (IllegalArgumentException e) {
            if (StringUtil.isEmpty((CharSequence)this.name)) {
                throw new IllegalArgumentException("Error parsing column '" + this.name + "'. ", e);
            }
            throw e;
        }
    }

    public Object parse(String text) throws ParseException {
        try {
            return this.format.parseObject(text);
        }
        catch (IllegalArgumentException e) {
            if (StringUtil.isEmpty((CharSequence)this.name)) {
                throw new IllegalArgumentException("Error parsing column '" + this.name + "'. ", e);
            }
            throw e;
        }
    }

    private static int formatWidth(Format format) {
        if (format instanceof DateFormat) {
            return format.format(new Date()).length();
        }
        if (format instanceof NumberFormat) {
            return format.format(0).length();
        }
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.format == null ? 0 : this.format.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FixedWidthColumnDescriptor other = (FixedWidthColumnDescriptor)obj;
        if (this.format == null ? other.format != null : !this.format.equals((Object)other.format)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return this.name + '[' + this.format + ']';
    }
}

