/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.fixedwidth;

import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.util.regex.Pattern;
import org.databene.commons.IOUtil;
import org.databene.commons.ReaderLineIterator;
import org.databene.commons.StringUtil;
import org.databene.commons.SystemInfo;
import org.databene.commons.format.PadFormat;
import org.databene.formats.DataContainer;
import org.databene.formats.DataIterator;
import org.databene.formats.fixedwidth.FixedWidthLineParser;

public class FixedWidthLineIterator
implements DataIterator<String[]> {
    private boolean ignoreEmptyLines;
    private ReaderLineIterator lineIterator;
    private FixedWidthLineParser parser;
    private int lineCount;
    private Pattern lineFilter;

    public FixedWidthLineIterator(String uri, PadFormat[] formats) throws IOException {
        this(uri, formats, false, SystemInfo.getFileEncoding(), null);
    }

    public FixedWidthLineIterator(String uri, PadFormat[] formats, boolean ignoreEmptyLines, String encoding, String lineFilter) throws IOException {
        this(IOUtil.getReaderForURI((String)uri, (String)encoding), formats, ignoreEmptyLines, lineFilter);
    }

    public FixedWidthLineIterator(Reader reader, PadFormat[] formats) {
        this(reader, formats, false, null);
    }

    public FixedWidthLineIterator(Reader reader, PadFormat[] formats, boolean ignoreEmptyLines, String lineFilter) {
        this.lineIterator = new ReaderLineIterator(reader);
        this.parser = new FixedWidthLineParser(formats);
        this.ignoreEmptyLines = ignoreEmptyLines;
        this.lineCount = 0;
        this.lineFilter = lineFilter != null ? Pattern.compile(lineFilter) : null;
    }

    @Override
    public Class<String[]> getType() {
        return String[].class;
    }

    @Override
    public DataContainer<String[]> next(DataContainer<String[]> wrapper) {
        String[] result = this.fetchNextLine();
        if (result != null) {
            ++this.lineCount;
            return wrapper.setData(result);
        }
        return null;
    }

    @Override
    public void close() {
        if (this.lineIterator != null) {
            this.lineIterator.close();
        }
        this.lineIterator = null;
    }

    public int lineCount() {
        return this.lineCount;
    }

    private String[] fetchNextLine() {
        try {
            if (this.lineIterator == null) {
                return null;
            }
            String line = null;
            boolean success = false;
            while (this.lineIterator.hasNext()) {
                ++this.lineCount;
                line = this.lineIterator.next();
                if (line.length() <= 0 && this.ignoreEmptyLines || this.lineFilter != null && !this.lineFilter.matcher(line).matches()) continue;
                success = true;
                break;
            }
            if (!success) {
                this.close();
                return null;
            }
            if (StringUtil.isEmpty(line)) {
                return new String[0];
            }
            return this.parser.parse(line);
        }
        catch (ParseException e) {
            throw new RuntimeException("Unexpected error. ", e);
        }
    }
}

