/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.fixedwidth;

import java.text.ParseException;
import java.text.ParsePosition;
import org.databene.commons.ArrayBuilder;
import org.databene.commons.BeanUtil;
import org.databene.commons.SyntaxError;
import org.databene.commons.accessor.GraphAccessor;
import org.databene.commons.mutator.AnyMutator;
import org.databene.formats.fixedwidth.FixedWidthColumnDescriptor;

public class FixedWidthRowTypeDescriptor {
    private String name;
    private FixedWidthColumnDescriptor[] columnDescriptors;
    private int rowLength;

    public FixedWidthRowTypeDescriptor(String name, FixedWidthColumnDescriptor[] columnDescriptors) {
        this.name = name;
        this.columnDescriptors = columnDescriptors;
        this.rowLength = FixedWidthRowTypeDescriptor.totalLength(columnDescriptors);
    }

    public String getName() {
        return this.name;
    }

    public FixedWidthColumnDescriptor[] getColumnDescriptors() {
        return this.columnDescriptors;
    }

    public String formatBean(Object rowBean) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.columnDescriptors.length; ++i) {
            String path = this.columnDescriptors[i].getName();
            Object value = GraphAccessor.getValue((String)path, (Object)rowBean);
            builder.append(this.columnDescriptors[i].format(value));
        }
        return builder.toString();
    }

    public String formatArray(Object ... columnValues) {
        if (columnValues.length != this.columnDescriptors.length) {
            throw new IllegalArgumentException("Row type '" + this.name + "' expects " + columnValues.length + " array elements " + ", but found: " + columnValues.length);
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.columnDescriptors.length; ++i) {
            builder.append(this.columnDescriptors[i].format(columnValues[i]));
        }
        return builder.toString();
    }

    public Object[] parseAsArray(String row) {
        if (row.length() != this.rowLength) {
            throw new SyntaxError("Row of type '" + this.name + "' has illegal length. " + "Expected: " + this.rowLength + ", found: " + row.length(), "'" + row + "'");
        }
        ArrayBuilder builder = new ArrayBuilder(Object.class);
        ParsePosition pos = new ParsePosition(0);
        for (int i = 0; i < this.columnDescriptors.length; ++i) {
            FixedWidthColumnDescriptor columnDescriptor = this.columnDescriptors[i];
            int endIndex = pos.getIndex() + columnDescriptor.getWidth();
            String cellContent = row.substring(pos.getIndex(), endIndex);
            try {
                Object cellObject = columnDescriptor.parse(cellContent);
                builder.add(cellObject);
            }
            catch (ParseException e) {
                throw new SyntaxError("Error parsing column '" + FixedWidthRowTypeDescriptor.descriptorName(columnDescriptor, i) + "'. " + e.getMessage(), cellContent);
            }
            pos.setIndex(endIndex);
        }
        return builder.toArray();
    }

    public <T> T parseAsBean(String row, Class<T> beanClass) {
        if (row.length() != this.rowLength) {
            throw new SyntaxError("Row of type '" + this.name + "' has illegal length. " + "Expected: " + this.rowLength + ", found: " + row.length(), "'" + row + "'");
        }
        Object bean = BeanUtil.newInstance(beanClass);
        ParsePosition pos = new ParsePosition(0);
        for (FixedWidthColumnDescriptor columnDescriptor : this.columnDescriptors) {
            int endIndex = pos.getIndex() + columnDescriptor.getWidth();
            String cellContent = row.substring(pos.getIndex(), endIndex);
            try {
                Object cellObject = columnDescriptor.parse(cellContent);
                AnyMutator.setValue((Object)bean, (String)columnDescriptor.getName(), (Object)cellObject, (boolean)true, (boolean)true);
            }
            catch (ParseException e) {
                throw new SyntaxError("Error parsing column '" + columnDescriptor + "'. " + e.getMessage(), cellContent);
            }
            pos.setIndex(endIndex);
        }
        return (T)bean;
    }

    private static String descriptorName(FixedWidthColumnDescriptor descriptor, int i) {
        return descriptor.getName() != null ? descriptor.getName() : String.valueOf(i);
    }

    private static int totalLength(FixedWidthColumnDescriptor[] descriptors) {
        int result = 0;
        for (FixedWidthColumnDescriptor descriptor : descriptors) {
            result += descriptor.getWidth();
        }
        return result;
    }
}

