/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.fixedwidth;

import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.databene.commons.ConfigurationError;
import org.databene.commons.ParseUtil;
import org.databene.commons.StringUtil;
import org.databene.commons.SyntaxError;
import org.databene.commons.format.Alignment;
import org.databene.formats.fixedwidth.FixedWidthColumnDescriptor;
import org.databene.formats.fixedwidth.FixedWidthRowTypeDescriptor;

public class FixedWidthUtil {
    public static FixedWidthRowTypeDescriptor parseBeanColumnsSpec(String properties, String rowTypeName, String nullString, Locale locale) throws ParseException {
        if (properties == null) {
            return null;
        }
        String[] propertyFormats = StringUtil.tokenize((String)properties, (char)',');
        FixedWidthColumnDescriptor[] columns = new FixedWidthColumnDescriptor[propertyFormats.length];
        for (int i = 0; i < propertyFormats.length; ++i) {
            String propertyFormat = propertyFormats[i];
            int lbIndex = propertyFormat.indexOf(91);
            if (lbIndex < 0) {
                throw new ConfigurationError("'[' expected in property format descriptor '" + propertyFormat + "'");
            }
            int rbIndex = propertyFormat.indexOf(93);
            if (rbIndex < 0) {
                throw new ConfigurationError("']' expected in property format descriptor '" + propertyFormat + "'");
            }
            String propertyName = propertyFormat.substring(0, lbIndex);
            String formatSpec = propertyFormat.substring(lbIndex + 1, rbIndex);
            FixedWidthColumnDescriptor descriptor = FixedWidthUtil.parseColumnFormat(formatSpec, nullString, locale);
            descriptor.setName(propertyName);
            columns[i] = descriptor;
        }
        return new FixedWidthRowTypeDescriptor(rowTypeName, columns);
    }

    public static FixedWidthRowTypeDescriptor parseArrayColumnsSpec(String columnsSpec, String rowTypeName, String nullString, Locale locale) throws ParseException {
        if (columnsSpec == null) {
            return null;
        }
        String[] columnFormats = StringUtil.tokenize((String)columnsSpec, (char)',');
        FixedWidthColumnDescriptor[] columns = new FixedWidthColumnDescriptor[columnFormats.length];
        for (int i = 0; i < columnFormats.length; ++i) {
            columns[i] = FixedWidthUtil.parseColumnFormat(columnFormats[i], nullString, locale);
        }
        return new FixedWidthRowTypeDescriptor(rowTypeName, columns);
    }

    public static FixedWidthColumnDescriptor parseColumnFormat(String formatSpec, String nullString, Locale locale) throws ParseException {
        switch (formatSpec.charAt(0)) {
            case 'D': {
                return FixedWidthUtil.parseDatePattern(formatSpec, nullString, locale);
            }
            case 'N': {
                return FixedWidthUtil.parseNumberPattern(formatSpec, nullString, locale);
            }
        }
        return FixedWidthUtil.parseWidthFormat(formatSpec, nullString);
    }

    private static FixedWidthColumnDescriptor parseDatePattern(String formatSpec, String nullString, Locale locale) {
        if (!formatSpec.startsWith("D")) {
            throw new SyntaxError("Illegal date/time pattern", formatSpec);
        }
        String pattern = formatSpec.substring(1);
        SimpleDateFormat format = new SimpleDateFormat(pattern, DateFormatSymbols.getInstance(locale));
        return new FixedWidthColumnDescriptor(null, format, nullString);
    }

    private static FixedWidthColumnDescriptor parseNumberPattern(String formatSpec, String nullString, Locale locale) {
        if (!formatSpec.startsWith("N")) {
            throw new SyntaxError("Illegal number pattern", formatSpec);
        }
        String pattern = formatSpec.substring(1);
        DecimalFormat format = new DecimalFormat(pattern, DecimalFormatSymbols.getInstance(locale));
        return new FixedWidthColumnDescriptor(null, format, nullString);
    }

    private static FixedWidthColumnDescriptor parseWidthFormat(String formatSpec, String nullString) throws ParseException {
        ParsePosition pos = new ParsePosition(0);
        int width = (int)ParseUtil.parseNonNegativeInteger((String)formatSpec, (ParsePosition)pos);
        NumberFormat format = null;
        int minFractionDigits = 0;
        int maxFractionDigits = 2;
        if (pos.getIndex() < formatSpec.length() && formatSpec.charAt(pos.getIndex()) == '.') {
            pos.setIndex(pos.getIndex() + 1);
            maxFractionDigits = minFractionDigits = (int)ParseUtil.parseNonNegativeInteger((String)formatSpec, (ParsePosition)pos);
            format = DecimalFormat.getInstance(Locale.US);
            format.setMinimumFractionDigits(minFractionDigits);
            format.setMaximumFractionDigits(maxFractionDigits);
            format.setGroupingUsed(false);
        }
        Alignment alignment = Alignment.LEFT;
        if (pos.getIndex() < formatSpec.length()) {
            char alignmentCode = formatSpec.charAt(pos.getIndex());
            switch (alignmentCode) {
                case 'l': {
                    alignment = Alignment.LEFT;
                    break;
                }
                case 'r': {
                    alignment = Alignment.RIGHT;
                    break;
                }
                case 'c': {
                    alignment = Alignment.CENTER;
                    break;
                }
                default: {
                    throw new ConfigurationError("Illegal alignment code '" + alignmentCode + "' in format descriptor '" + formatSpec + "'");
                }
            }
            pos.setIndex(pos.getIndex() + 1);
        }
        char padChar = ' ';
        if (pos.getIndex() < formatSpec.length()) {
            padChar = formatSpec.charAt(pos.getIndex());
            pos.setIndex(pos.getIndex() + 1);
        }
        if (pos.getIndex() != formatSpec.length()) {
            throw new SyntaxError("Illegal column format", formatSpec);
        }
        return new FixedWidthColumnDescriptor(null, format, nullString, width, alignment, padChar);
    }
}

