/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.fixedwidth;

import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.databene.commons.Assert;
import org.databene.commons.SystemInfo;
import org.databene.formats.fixedwidth.FixedWidthRowTypeDescriptor;

public class MultiTypeArrayFixedWidthWriter
implements Closeable {
    private final Writer out;
    private Map<String, FixedWidthRowTypeDescriptor> rowDescriptors;

    public MultiTypeArrayFixedWidthWriter(Writer out) {
        this(out, null);
    }

    public MultiTypeArrayFixedWidthWriter(Writer out, List<FixedWidthRowTypeDescriptor> rowDescriptors) {
        Assert.notNull((Object)out, (String)"Writer");
        this.out = out;
        this.rowDescriptors = new HashMap<String, FixedWidthRowTypeDescriptor>();
        if (rowDescriptors != null) {
            for (FixedWidthRowTypeDescriptor rowDescriptor : rowDescriptors) {
                this.addRowFormat(rowDescriptor);
            }
        }
    }

    public void addRowFormat(FixedWidthRowTypeDescriptor rowDescriptor) {
        this.rowDescriptors.put(rowDescriptor.getName(), rowDescriptor);
    }

    public void write(String rowTypeName, Object ... values) throws IOException {
        Assert.notNull((Object)values, (String)"array");
        FixedWidthRowTypeDescriptor rowType = this.rowDescriptors.get(rowTypeName);
        if (rowType == null) {
            throw new IllegalArgumentException("Illegal row type: " + rowTypeName);
        }
        this.out.write(rowType.formatArray(values));
        this.out.write(SystemInfo.getLineSeparator());
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

