/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.fixedwidth;

import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.databene.commons.Assert;
import org.databene.commons.SystemInfo;
import org.databene.formats.fixedwidth.FixedWidthRowTypeDescriptor;

public class MultiTypeBeanFixedWidthWriter
implements Closeable {
    private final Writer out;
    private Map<String, FixedWidthRowTypeDescriptor> rowDescriptors;

    public MultiTypeBeanFixedWidthWriter(Writer out) {
        this(out, null);
    }

    public MultiTypeBeanFixedWidthWriter(Writer out, List<FixedWidthRowTypeDescriptor> rowDescriptors) {
        Assert.notNull((Object)out, (String)"Writer");
        this.out = out;
        this.rowDescriptors = new HashMap<String, FixedWidthRowTypeDescriptor>();
        if (rowDescriptors != null) {
            for (FixedWidthRowTypeDescriptor rowDescriptor : rowDescriptors) {
                this.addRowFormat(rowDescriptor.getName(), rowDescriptor);
            }
        }
    }

    public void addRowFormat(String simpleClassName, FixedWidthRowTypeDescriptor rowDescriptor) {
        this.rowDescriptors.put(simpleClassName, rowDescriptor);
    }

    public FixedWidthRowTypeDescriptor getRowFormat(String simpleClassName) {
        return this.rowDescriptors.get(simpleClassName);
    }

    public void write(Object bean) throws IOException {
        Assert.notNull((Object)bean, (String)"bean");
        FixedWidthRowTypeDescriptor cellFormats = this.rowDescriptors.get(bean.getClass().getSimpleName());
        if (cellFormats == null) {
            throw new IllegalArgumentException("Bean class not configured: " + bean.getClass().getSimpleName());
        }
        this.out.write(cellFormats.formatBean(bean));
        this.out.write(SystemInfo.getLineSeparator());
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

