/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.html;

import java.io.File;
import java.io.IOException;
import org.databene.commons.FileUtil;
import org.databene.formats.html.Anchor;

public class FileAnchor
extends Anchor {
    public final File file;

    public FileAnchor(File file, String label) {
        super(label);
        this.file = file;
    }

    public FileAnchor(File file, String label, String target) {
        super(label, target);
        this.file = file;
    }

    public static FileAnchor createAnchorForNewWindow(File file, String label) {
        return new FileAnchor(file, label, "_blank");
    }

    public String relativeLinkFrom(File referer) {
        return this.linkForURL(FileUtil.relativePath((File)referer, (File)this.file, (char)'/'));
    }

    public String toString() {
        try {
            return this.linkForURL("file://" + this.file.getCanonicalPath());
        }
        catch (IOException e) {
            e.printStackTrace();
            return this.linkForURL("file://" + this.file.getAbsolutePath());
        }
    }

    private String linkForURL(String url) {
        return "<a href='" + url + "'" + (this.target != null ? " target='" + this.target + "'" : "") + ">" + this.label + "</a>";
    }
}

