/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.html.model;

import java.io.IOException;
import org.databene.commons.IOUtil;
import org.databene.formats.html.model.CssStyle;
import org.databene.formats.html.model.HtmlElement;
import org.databene.formats.html.model.Link;

public class Head
extends HtmlElement<Head> {
    public Head() {
        super("head", false);
    }

    @Override
    public Head withTitle(String title) {
        return (Head)this.withAttribute("title", title);
    }

    public Head withCssStyleSheet(String cssPath) {
        Link link = new Link().withRel("stylesheet").withType("text/css").withHref(cssPath);
        return (Head)this.addComponent(link);
    }

    public Head withInlineCssStyleSheet(String cssFilePath) {
        try {
            String content = IOUtil.getContentOfURI((String)cssFilePath);
            CssStyle style = (CssStyle)new CssStyle().withRawTextContent(content);
            return (Head)this.addComponent(style);
        }
        catch (IOException e) {
            throw new RuntimeException("Error inlining css file: " + cssFilePath, e);
        }
    }
}

