/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.html.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.databene.commons.SystemInfo;
import org.databene.commons.collection.OrderedNameMap;
import org.databene.formats.html.model.HtmlComponent;
import org.databene.formats.html.model.HtmlFactory;
import org.databene.formats.html.model.TextComponent;

public class HtmlElement<E extends HtmlElement<?>>
extends HtmlComponent {
    private String tagName;
    protected boolean inline;
    protected OrderedNameMap<String> attributes;
    private List<HtmlComponent> components;

    public HtmlElement(String tagName, boolean inline) {
        this.tagName = tagName;
        this.inline = inline;
        this.attributes = new OrderedNameMap();
        this.components = new ArrayList<HtmlComponent>();
    }

    public E withClass(String klass) {
        return this.withAttribute("class", klass);
    }

    public E withStyle(String style) {
        return this.withAttribute("style", style);
    }

    public E withTitle(String title) {
        return this.withAttribute("title", title);
    }

    public E withAlign(String align) {
        return this.withAttribute("align", align);
    }

    public E withValign(String valign) {
        return this.withAttribute("valign", valign);
    }

    protected E withAttribute(String attributeName, String attributeValue) {
        this.attributes.put((Object)attributeName, (Object)attributeValue);
        return (E)this;
    }

    public E addBreak() {
        return this.addComponent(HtmlFactory.br());
    }

    public E withRawTextContent(String text) {
        return this.withTextContent(text, false, false);
    }

    public E withTextContent(String text, boolean escape, boolean convertLinefeeds) {
        return this.withComponents(new TextComponent(text, escape, convertLinefeeds));
    }

    public E withComponents(HtmlComponent ... newComponents) {
        this.setComponents(newComponents);
        return (E)this;
    }

    public void setComponents(HtmlComponent ... newComponents) {
        this.components.clear();
        for (HtmlComponent component : newComponents) {
            this.addComponent(component);
        }
    }

    public E addComponent(String textToAdd) {
        return this.addComponent(new TextComponent(textToAdd));
    }

    public void addComponents(HtmlComponent ... components) {
        for (HtmlComponent component : components) {
            this.addComponent(component);
        }
    }

    public E addComponent(HtmlComponent componentToAdd) {
        this.components.add(componentToAdd);
        return (E)this;
    }

    public String getTagName() {
        return this.tagName;
    }

    public boolean isInline() {
        return this.inline;
    }

    protected String formatStartTag() {
        StringBuilder builder = new StringBuilder();
        builder.append('<').append(this.tagName);
        for (Map.Entry att : this.attributes.entrySet()) {
            builder.append(' ').append((String)att.getKey()).append("=\"").append((String)att.getValue()).append('\"');
        }
        builder.append('>');
        if (!this.inline) {
            builder.append(SystemInfo.getLineSeparator());
        }
        return builder.toString();
    }

    protected String formatComponents() {
        StringBuilder builder = new StringBuilder();
        for (HtmlComponent component : this.components) {
            builder.append(component);
        }
        return builder.toString();
    }

    protected String formatEndTag() {
        StringBuilder builder = new StringBuilder();
        if (!this.inline) {
            builder.append(SystemInfo.getLineSeparator());
        }
        builder.append("</").append(this.tagName).append('>');
        if (!this.inline) {
            builder.append(SystemInfo.getLineSeparator());
        }
        return builder.toString();
    }

    @Override
    public String toString() {
        return this.formatStartTag() + this.formatComponents() + this.formatEndTag();
    }
}

