/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.regex;

import java.util.Arrays;
import java.util.List;
import org.databene.formats.regex.RegexPart;

public class Choice
implements RegexPart {
    private RegexPart[] alternatives;

    public Choice(List<RegexPart> alternatives) {
        RegexPart[] ra = new RegexPart[alternatives.size()];
        this.alternatives = alternatives.toArray(ra);
    }

    public Choice(RegexPart ... alternatives) {
        this.alternatives = alternatives;
    }

    public RegexPart[] getAlternatives() {
        return this.alternatives;
    }

    @Override
    public int minLength() {
        if (this.alternatives.length == 0) {
            return 0;
        }
        int min = this.alternatives[0].minLength();
        for (int i = this.alternatives.length - 1; i >= 1; --i) {
            min = Math.min(min, this.alternatives[i].minLength());
        }
        return min;
    }

    @Override
    public Integer maxLength() {
        if (this.alternatives.length == 0) {
            return 0;
        }
        int max = 0;
        for (RegexPart candidate : this.alternatives) {
            Integer partMaxLength = candidate.maxLength();
            if (partMaxLength == null) {
                return null;
            }
            if (partMaxLength <= max) continue;
            max = partMaxLength;
        }
        return max;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return Arrays.equals(this.alternatives, ((Choice)o).alternatives);
    }

    public int hashCode() {
        return Arrays.hashCode(this.alternatives);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("(");
        for (int i = 0; i < this.alternatives.length; ++i) {
            if (i > 0) {
                buffer.append('|');
            }
            buffer.append(this.alternatives[i]);
        }
        buffer.append(')');
        return buffer.toString();
    }
}

