/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.regex;

import java.util.ArrayList;
import java.util.List;
import org.databene.commons.CharSet;
import org.databene.formats.regex.RegexCharClass;

public class CustomCharClass
extends RegexCharClass {
    private List<RegexCharClass> inclusions = new ArrayList<RegexCharClass>();
    private List<RegexCharClass> exclusions;

    public CustomCharClass() {
        this(null);
    }

    public CustomCharClass(List<? extends RegexCharClass> includedSets) {
        this(includedSets, null);
    }

    public CustomCharClass(List<? extends RegexCharClass> includedSets, List<? extends RegexCharClass> excludedSets) {
        if (includedSets != null) {
            this.inclusions.addAll(includedSets);
        }
        this.exclusions = new ArrayList<RegexCharClass>();
        if (excludedSets != null) {
            this.exclusions.addAll(excludedSets);
        }
    }

    @Override
    public CharSet getCharSet() {
        CharSet set = new CharSet();
        for (RegexCharClass inclusion : this.inclusions) {
            set.addAll(inclusion.getCharSet().getSet());
        }
        for (RegexCharClass exclusion : this.exclusions) {
            set.removeAll(exclusion.getCharSet().getSet());
        }
        return set;
    }

    public void addInclusion(RegexCharClass set) {
        this.inclusions.add(set);
    }

    public void addExclusions(RegexCharClass set) {
        this.exclusions.add(set);
    }

    public boolean hasInclusions() {
        return !this.inclusions.isEmpty();
    }

    private static void appendToString(List<?> objects, StringBuilder builder) {
        for (Object object : objects) {
            builder.append(object);
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder("[");
        CustomCharClass.appendToString(this.inclusions, result);
        if (!this.exclusions.isEmpty()) {
            result.append('^');
            CustomCharClass.appendToString(this.exclusions, result);
        }
        return result.append(']').toString();
    }

    public int hashCode() {
        return 31 * this.exclusions.hashCode() + this.inclusions.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CustomCharClass that = (CustomCharClass)obj;
        return this.inclusions.equals(that.inclusions) && this.exclusions.equals(that.exclusions);
    }
}

