/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.regex;

import org.databene.formats.regex.Quantifier;
import org.databene.formats.regex.RegexPart;

public class Factor
implements RegexPart {
    private RegexPart atom;
    private Quantifier quantifier;

    public Factor(RegexPart pattern) {
        this(pattern, 1, 1);
    }

    public Factor(RegexPart atom, int minQuantity, Integer maxQuantity) {
        this(atom, new Quantifier(minQuantity, maxQuantity));
    }

    public Factor(RegexPart atom, Quantifier quantifier) {
        this.atom = atom;
        this.quantifier = quantifier;
    }

    public RegexPart getAtom() {
        return this.atom;
    }

    public Quantifier getQuantifier() {
        return this.quantifier;
    }

    @Override
    public int minLength() {
        return this.atom.minLength() * this.quantifier.getMin();
    }

    @Override
    public Integer maxLength() {
        Integer maxAtomLength = this.atom.maxLength();
        Integer maxQuantifier = this.quantifier.getMax();
        return maxAtomLength != null && maxQuantifier != null ? Integer.valueOf(maxAtomLength * maxQuantifier) : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Factor that = (Factor)o;
        return this.atom.equals(that.atom) && that.quantifier.equals(that.quantifier);
    }

    public int hashCode() {
        return 29 * this.atom.hashCode() + this.quantifier.hashCode();
    }

    public String toString() {
        return this.atom.toString() + this.quantifier.toString();
    }
}

