/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.regex;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.antlr.runtime.ANTLRReaderStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.ParserRuleReturnScope;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.databene.commons.Assert;
import org.databene.commons.CharSet;
import org.databene.commons.CollectionUtil;
import org.databene.commons.LocaleUtil;
import org.databene.commons.StringUtil;
import org.databene.commons.SyntaxError;
import org.databene.formats.regex.CharRange;
import org.databene.formats.regex.Choice;
import org.databene.formats.regex.CustomCharClass;
import org.databene.formats.regex.Factor;
import org.databene.formats.regex.Group;
import org.databene.formats.regex.Quantifier;
import org.databene.formats.regex.RegexChar;
import org.databene.formats.regex.RegexCharClass;
import org.databene.formats.regex.RegexPart;
import org.databene.formats.regex.RegexString;
import org.databene.formats.regex.Sequence;
import org.databene.formats.regex.SimpleCharSet;
import org.databene.formats.regex.antlr.RegexLexer;
import org.databene.formats.regex.antlr.RegexParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegexParser.class);
    private Locale locale;

    public RegexParser() {
        this(LocaleUtil.getFallbackLocale());
    }

    public RegexParser(Locale locale) {
        this.locale = locale;
    }

    public RegexPart parseRegex(String pattern) throws SyntaxError {
        if (pattern == null) {
            return null;
        }
        if (pattern.length() == 0) {
            return new RegexString("");
        }
        try {
            RegexLexer lex = new RegexLexer((CharStream)new ANTLRReaderStream((Reader)new StringReader(pattern)));
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lex);
            org.databene.formats.regex.antlr.RegexParser parser = new org.databene.formats.regex.antlr.RegexParser((TokenStream)tokens);
            RegexParser.expression_return r = parser.expression();
            RegexParser.checkForSyntaxErrors(pattern, "regex", parser, r);
            if (r != null) {
                CommonTree tree = (CommonTree)r.getTree();
                LOGGER.debug("parsed {} to {}", (Object)pattern, (Object)tree.toStringTree());
                return this.convertRegexPart(tree);
            }
            return null;
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof RecognitionException) {
                throw RegexParser.mapToSyntaxError((RecognitionException)e.getCause(), pattern);
            }
            throw e;
        }
        catch (IOException e) {
            throw new IllegalStateException("Encountered illegal state in regex parsing", e);
        }
        catch (RecognitionException e) {
            throw RegexParser.mapToSyntaxError(e, pattern);
        }
    }

    public RegexCharClass parseSingleChar(String pattern) throws SyntaxError {
        if (pattern == null) {
            return null;
        }
        if (pattern.length() == 0) {
            throw new IllegalArgumentException("Not a character class pattern: '" + pattern + "'");
        }
        try {
            RegexLexer lex = new RegexLexer((CharStream)new ANTLRReaderStream((Reader)new StringReader(pattern)));
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lex);
            org.databene.formats.regex.antlr.RegexParser parser = new org.databene.formats.regex.antlr.RegexParser((TokenStream)tokens);
            RegexParser.singlechar_return r = parser.singlechar();
            if (parser.getNumberOfSyntaxErrors() > 0) {
                throw new SyntaxError("Illegal regex", pattern);
            }
            if (r != null) {
                CommonTree tree = (CommonTree)r.getTree();
                LOGGER.debug("parsed {} to {}", (Object)pattern, (Object)tree.toStringTree());
                RegexPart regex = this.convertRegexPart(tree);
                if (!(regex instanceof RegexCharClass)) {
                    throw new IllegalArgumentException("Not a character class pattern: '" + pattern + "'");
                }
                return (RegexCharClass)regex;
            }
            return null;
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof RecognitionException) {
                throw RegexParser.mapToSyntaxError((RecognitionException)e.getCause(), pattern);
            }
            throw e;
        }
        catch (IOException e) {
            throw new IllegalStateException("Encountered illegal state in regex parsing", e);
        }
        catch (RecognitionException e) {
            throw RegexParser.mapToSyntaxError(e, pattern);
        }
    }

    private static SyntaxError mapToSyntaxError(RecognitionException e, String parsedText) {
        return new SyntaxError("Error parsing regular expression: " + e.getMessage(), parsedText, e.charPositionInLine, e.line);
    }

    private RegexPart convertRegexPart(CommonTree node) throws SyntaxError {
        if (node == null) {
            return null;
        }
        if (node.getToken() == null) {
            return new RegexString("");
        }
        switch (node.getType()) {
            case 15: {
                return this.convertChoice(node);
            }
            case 14: {
                return this.convertGroup(node);
            }
            case 16: {
                return this.convertSequence(node);
            }
            case 17: {
                return this.convertFactor(node);
            }
            case 4: {
                return this.convertPredefClass(node);
            }
            case 18: {
                return this.convertClass(node);
            }
            case 19: {
                return this.convertRange(node);
            }
            case 6: {
                return RegexParser.convertAlphanum(node);
            }
            case 7: {
                return RegexParser.convertEscaped(node);
            }
            case 8: {
                return RegexParser.convertNonTypeable(node);
            }
            case 9: {
                return RegexParser.convertOctal(node);
            }
            case 10: {
                return RegexParser.convertHexChar(node);
            }
            case 11: {
                return RegexParser.convertCodedChar(node);
            }
            case 5: {
                return RegexParser.convertAlphanum(node);
            }
        }
        throw new SyntaxError("Not a supported token type: " + node.getToken(), node.toString(), node.getCharPositionInLine(), node.getLine());
    }

    private Group convertGroup(CommonTree node) throws SyntaxError {
        List childNodes = node.getChildren();
        Assert.equals((Object)1, (Object)childNodes.size(), (String)"Group is expected to have exactly one child node");
        return new Group(this.convertRegexPart((CommonTree)childNodes.get(0)));
    }

    private Choice convertChoice(CommonTree node) throws SyntaxError {
        List childNodes = node.getChildren();
        ArrayList<RegexPart> childPatterns = new ArrayList<RegexPart>();
        if (childNodes != null) {
            for (CommonTree childNode : childNodes) {
                childPatterns.add(this.convertRegexPart(childNode));
            }
        }
        return new Choice((RegexPart[])CollectionUtil.toArray(childPatterns, RegexPart.class));
    }

    private Sequence convertSequence(CommonTree tree) throws SyntaxError {
        List childNodes = tree.getChildren();
        ArrayList<RegexPart> children = new ArrayList<RegexPart>();
        if (childNodes != null) {
            for (CommonTree child : childNodes) {
                children.add(this.convertRegexPart(child));
            }
        }
        return new Sequence((RegexPart[])CollectionUtil.toArray(children, RegexPart.class));
    }

    private Factor convertFactor(CommonTree tree) throws SyntaxError {
        List children = tree.getChildren();
        RegexPart subPattern = this.convertRegexPart((CommonTree)children.get(0));
        Quantifier quantifier = null;
        quantifier = children.size() > 1 ? RegexParser.convertQuantifier((CommonTree)children.get(1)) : new Quantifier(1, 1);
        return new Factor(subPattern, quantifier);
    }

    private CustomCharClass convertClass(CommonTree node) throws SyntaxError {
        CustomCharClass result = new CustomCharClass();
        List childNodes = node.getChildren();
        if (childNodes != null) {
            for (CommonTree child : childNodes) {
                List gdChildren;
                if (child.getType() == 20) {
                    gdChildren = child.getChildren();
                    if (gdChildren == null) continue;
                    for (CommonTree gdChild : gdChildren) {
                        result.addInclusion((RegexCharClass)this.convertRegexPart(gdChild));
                    }
                    continue;
                }
                gdChildren = child.getChildren();
                if (gdChildren == null) continue;
                for (CommonTree gdChild : gdChildren) {
                    result.addExclusions((RegexCharClass)this.convertRegexPart(gdChild));
                }
            }
        }
        if (!result.hasInclusions()) {
            result.addInclusion(new SimpleCharSet(".", new CharSet().addAnyCharacters()));
        }
        return result;
    }

    private static RegexChar convertAlphanum(CommonTree node) {
        return new RegexChar(node.getText().charAt(0));
    }

    private static RegexChar convertNonTypeable(CommonTree node) throws SyntaxError {
        switch (node.getText().charAt(1)) {
            case 'r': {
                return new RegexChar('\r');
            }
            case 'n': {
                return new RegexChar('\n');
            }
            case 't': {
                return new RegexChar('\t');
            }
            case 'f': {
                return new RegexChar('\f');
            }
            case 'a': {
                return new RegexChar('\u0007');
            }
            case 'e': {
                return new RegexChar('\u001b');
            }
        }
        throw new SyntaxError("invalid non-typeable char", node.getText(), node.getCharPositionInLine(), node.getLine());
    }

    private static RegexChar convertOctal(CommonTree node) {
        return new RegexChar((char)Integer.parseInt(node.getText().substring(2), 8));
    }

    private static RegexChar convertHexChar(CommonTree node) {
        return new RegexChar((char)Integer.parseInt(node.getText().substring(2), 16));
    }

    private static RegexChar convertCodedChar(CommonTree node) {
        return new RegexChar((char)(Character.toUpperCase(node.getText().charAt(2)) - 65));
    }

    private RegexCharClass convertPredefClass(CommonTree node) throws SyntaxError {
        String text = node.getText();
        if (".".equals(text)) {
            return new SimpleCharSet(".", CharSet.getAnyCharacters());
        }
        char charClass = text.charAt(1);
        switch (charClass) {
            case 'd': {
                return new SimpleCharSet("\\d", CharSet.getDigits());
            }
            case 'D': {
                return new SimpleCharSet("\\D", CharSet.getNonDigits());
            }
            case 's': {
                return new SimpleCharSet("\\s", CharSet.getWhitespaces());
            }
            case 'S': {
                return new SimpleCharSet("\\S", CharSet.getNonWhitespaces());
            }
            case 'w': {
                return new SimpleCharSet("\\w", CharSet.getWordChars((Locale)this.locale));
            }
            case 'W': {
                return new SimpleCharSet("\\W", CharSet.getNonWordChars());
            }
        }
        throw new SyntaxError("Unsupported character class", text, node.getCharPositionInLine(), node.getLine());
    }

    private static RegexChar convertEscaped(CommonTree node) {
        String text = node.getText();
        return new RegexChar(text.charAt(1));
    }

    private RegexCharClass convertRange(CommonTree node) throws SyntaxError {
        List children = node.getChildren();
        CommonTree fromNode = (CommonTree)children.get(0);
        char from = ((RegexChar)this.convertRegexPart(fromNode)).getChar();
        CommonTree toNode = (CommonTree)children.get(1);
        char to = ((RegexChar)this.convertRegexPart(toNode)).getChar();
        return new CharRange(fromNode.getText() + "-" + toNode.getText(), from, to);
    }

    private static Quantifier convertQuantifier(CommonTree node) throws SyntaxError {
        switch (node.getType()) {
            case 12: {
                return RegexParser.convertSimpleQuantifier(node);
            }
            case 22: {
                return RegexParser.convertExplicitQuantifier(node);
            }
        }
        throw new SyntaxError("Error parsing quantifier", node.getText(), node.getCharPositionInLine(), node.getLine());
    }

    private static Quantifier convertExplicitQuantifier(CommonTree tree) {
        int min = 0;
        Integer max = null;
        List children = tree.getChildren();
        min = RegexParser.convertInt((CommonTree)children.get(0));
        if (children.size() > 1) {
            max = RegexParser.convertInt((CommonTree)children.get(1));
        }
        Quantifier result = new Quantifier(min, max);
        return result;
    }

    private static Integer convertInt(CommonTree node) {
        Assert.equals((Object)13, (Object)node.getType(), (String)"node is not an integer");
        return Integer.parseInt(node.getText());
    }

    private static Quantifier convertSimpleQuantifier(CommonTree node) throws SyntaxError {
        Assert.equals((Object)12, (Object)node.getType(), (String)"node is not an simple quantifier");
        char letter = node.getText().charAt(0);
        switch (letter) {
            case '?': {
                return new Quantifier(0, 1);
            }
            case '*': {
                return new Quantifier(0, null);
            }
            case '+': {
                return new Quantifier(1, null);
            }
        }
        throw new SyntaxError("Error parsing simple quantifier", node.getText(), node.getCharPositionInLine(), node.getLine());
    }

    private static void checkForSyntaxErrors(String text, String type, org.databene.formats.regex.antlr.RegexParser parser, ParserRuleReturnScope r) {
        if (parser.getNumberOfSyntaxErrors() > 0) {
            throw new SyntaxError("Illegal " + type, text, -1, -1);
        }
        CommonToken stop = (CommonToken)r.stop;
        if (stop.getStopIndex() < StringUtil.trimRight((String)text).length() - 1) {
            if (stop.getStopIndex() == 0) {
                throw new SyntaxError("Syntax error after " + stop.getText(), text);
            }
            throw new SyntaxError("Syntax error", text);
        }
    }
}

