/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.regex;

import java.util.Arrays;
import org.databene.formats.regex.RegexPart;

public class Sequence
implements RegexPart {
    private RegexPart[] factors;

    public Sequence(RegexPart ... factors) {
        this.factors = factors;
    }

    public RegexPart[] getFactors() {
        return this.factors;
    }

    @Override
    public int minLength() {
        int min = 0;
        for (RegexPart part : this.factors) {
            min += part.minLength();
        }
        return min;
    }

    @Override
    public Integer maxLength() {
        int max = 0;
        for (RegexPart part : this.factors) {
            Integer partMaxLength = part.maxLength();
            if (partMaxLength == null) {
                return null;
            }
            max += partMaxLength.intValue();
        }
        return max;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Sequence that = (Sequence)o;
        return Arrays.equals(this.factors, that.factors);
    }

    public int hashCode() {
        return Arrays.hashCode(this.factors);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (RegexPart factor : this.factors) {
            buffer.append(factor);
        }
        return buffer.toString();
    }
}

