/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.script;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.databene.commons.Context;
import org.databene.commons.DocumentWriter;
import org.databene.commons.context.DefaultContext;
import org.databene.formats.script.Script;
import org.databene.formats.script.ScriptUtil;

public class ScriptedDocumentWriter<E>
implements DocumentWriter<E> {
    private Writer out;
    private Map<String, Object> vars;
    private Script headerScript;
    private Script bodyPartScript;
    private Script footerScript;
    private boolean writeHeader;

    public ScriptedDocumentWriter(Writer out, String headerScriptUrl, String bodyPartScriptUrl, String footerScriptUrl) throws IOException {
        this(out, headerScriptUrl != null ? ScriptUtil.readFile(headerScriptUrl) : null, bodyPartScriptUrl != null ? ScriptUtil.readFile(bodyPartScriptUrl) : null, footerScriptUrl != null ? ScriptUtil.readFile(footerScriptUrl) : null);
    }

    public ScriptedDocumentWriter(Writer out, Script headerScript, Script bodyPartScript, Script footerScript) {
        this.out = out;
        this.headerScript = headerScript;
        this.bodyPartScript = bodyPartScript;
        this.footerScript = footerScript;
        this.vars = new HashMap<String, Object>();
        this.writeHeader = true;
    }

    public Script getHeaderScript() {
        return this.headerScript;
    }

    public void setHeaderScript(Script headerScript) {
        this.headerScript = headerScript;
    }

    public Script getFooterScript() {
        return this.footerScript;
    }

    public void setFooterScript(Script footerScript) {
        this.footerScript = footerScript;
    }

    public void setWriteHeader(boolean writeHeader) {
        this.writeHeader = writeHeader;
    }

    public void setVariable(String name, Object value) {
        this.vars.put(name, value);
    }

    public void writeElement(E part) throws IOException {
        if (this.writeHeader) {
            this.writeHeader();
            this.writeHeader = false;
        }
        if (this.bodyPartScript != null) {
            DefaultContext context = new DefaultContext();
            context.set("var", this.vars);
            context.set("part", part);
            this.bodyPartScript.execute((Context)context, this.out);
        }
    }

    public void close() throws IOException {
        this.writeFooter();
        this.out.close();
    }

    protected void writeHeader() throws IOException {
        if (this.headerScript != null) {
            DefaultContext context = new DefaultContext();
            context.set("var", this.vars);
            this.headerScript.execute((Context)context, this.out);
        }
    }

    protected void writeFooter() throws IOException {
        if (this.footerScript != null) {
            DefaultContext context = new DefaultContext();
            context.set("var", this.vars);
            this.footerScript.execute((Context)context, this.out);
        }
    }
}

