/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.script.freemarker;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.Locale;
import org.databene.commons.IOUtil;
import org.databene.formats.script.Script;
import org.databene.formats.script.ScriptFactory;
import org.databene.formats.script.freemarker.FreeMarkerScript;

public class FreeMarkerScriptFactory
implements ScriptFactory {
    private Configuration config = new Configuration();

    public FreeMarkerScriptFactory() {
        this(Locale.getDefault());
    }

    public FreeMarkerScriptFactory(Locale locale) {
        this.config.setClassForTemplateLoading(FreeMarkerScript.class, "/");
        this.config.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        this.config.setNumberFormat("0.##");
        this.config.setLocale(locale);
    }

    @Override
    public Script parseText(String text) {
        try {
            StringReader reader = new StringReader(text);
            Template template = new Template(text, (Reader)reader, this.config);
            return new FreeMarkerScript(template);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Script readFile(String uri) throws IOException {
        InputStreamReader reader = new InputStreamReader(IOUtil.getInputStreamForURI((String)uri), Charset.forName("UTF-8"));
        Template template = new Template(null, (Reader)reader, this.config);
        return new FreeMarkerScript(template);
    }
}

