/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.style;

import java.awt.Color;
import java.text.DecimalFormat;
import java.text.Format;
import org.databene.commons.format.Alignment;
import org.databene.commons.format.NullSafeFormat;
import org.databene.formats.style.StyledFormat;

public class StyledNumberFormat
extends StyledFormat {
    private static final long serialVersionUID = 1L;
    private final boolean negativeRed;

    public StyledNumberFormat(String pattern, boolean negativeRed) {
        super((Format)new NullSafeFormat((Format)new DecimalFormat(pattern), ""));
        this.negativeRed = negativeRed;
    }

    @Override
    public Alignment getAlignment() {
        return Alignment.RIGHT;
    }

    @Override
    public Color getForegroundColor(Object value, boolean isSelected) {
        return this.negativeRed && value instanceof Number && ((Number)value).doubleValue() < 0.0 ? Color.RED : null;
    }

    @Override
    public Color getBackgroundColor(Object value, boolean isSelected) {
        return null;
    }
}

