/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.text;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.databene.commons.LocaleUtil;
import org.databene.commons.ParseUtil;
import org.databene.commons.StringUtil;

public class AbbreviatedNumberFormat
extends NumberFormat {
    private static final long serialVersionUID = -3938256314974549704L;
    private static final Map<Locale, List<AbbreviatedScale>> ABBREVIATIONS = new HashMap<Locale, List<AbbreviatedScale>>();
    private String defaultScaleId;
    private double defaultScale;
    private List<AbbreviatedScale> abbreviations;
    private NumberFormat snf;

    private static void createAbbreviation(String abbreviation, Double factor, Locale locale) {
        List<AbbreviatedScale> localAbbrevs = ABBREVIATIONS.get(locale);
        if (localAbbrevs == null) {
            localAbbrevs = new ArrayList<AbbreviatedScale>();
            ABBREVIATIONS.put(locale, localAbbrevs);
        }
        AbbreviatedScale entry = new AbbreviatedScale(abbreviation, factor);
        localAbbrevs.add(entry);
    }

    public AbbreviatedNumberFormat() {
        this(1.0);
    }

    public AbbreviatedNumberFormat(double scale) {
        this(scale, Locale.getDefault());
    }

    public AbbreviatedNumberFormat(Locale locale) {
        this(1.0, locale);
    }

    public AbbreviatedNumberFormat(double scale, Locale locale) {
        this.abbreviations = AbbreviatedNumberFormat.abbreviationsForLocale(locale);
        this.defaultScale = scale;
        this.defaultScaleId = "";
        for (int i = 0; i < this.abbreviations.size(); ++i) {
            AbbreviatedScale abbScale = this.abbreviations.get(i);
            if (abbScale.factor != scale) continue;
            this.defaultScaleId = abbScale.code;
            break;
        }
        this.snf = NumberFormat.getInstance(locale);
        this.snf.setMinimumFractionDigits(2);
        this.snf.setMaximumFractionDigits(2);
        this.snf.setGroupingUsed(true);
    }

    @Override
    public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
        if (!StringUtil.isEmpty((CharSequence)this.defaultScaleId)) {
            return this.formatFixed(number, toAppendTo, pos);
        }
        return this.formatFree(number, toAppendTo, pos);
    }

    public StringBuffer formatFixed(double number, StringBuffer toAppendTo, FieldPosition pos) {
        this.snf.format(number / this.defaultScale, toAppendTo, pos);
        if (!StringUtil.isEmpty((CharSequence)this.defaultScaleId)) {
            toAppendTo.append(' ');
            toAppendTo.append(this.defaultScaleId);
        }
        return toAppendTo;
    }

    private StringBuffer formatFree(double number, StringBuffer toAppendTo, FieldPosition pos) {
        String selectedPrefix = "";
        for (int i = 0; i < this.abbreviations.size(); ++i) {
            double scale = this.abbreviations.get((int)i).factor;
            if (!(number >= scale)) continue;
            selectedPrefix = this.abbreviations.get((int)i).code;
            this.snf.format(number /= scale, toAppendTo, pos);
            toAppendTo.append(' ');
            toAppendTo.append(selectedPrefix);
            return toAppendTo;
        }
        return this.snf.format(number, toAppendTo, pos);
    }

    @Override
    public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.format((double)number, toAppendTo, pos);
    }

    @Override
    public Number parse(String source, ParsePosition pos) {
        Number value = this.snf.parse(StringUtil.trim((String)source), pos);
        int start = ParseUtil.nextNonWhitespaceIndex((String)source, (int)pos.getIndex());
        if (start == -1) {
            return value;
        }
        for (int i = 0; i < this.abbreviations.size(); ++i) {
            String prefix = this.abbreviations.get((int)i).code;
            if (!source.substring(start).startsWith(prefix)) continue;
            value = new Double(value.doubleValue() * Double.valueOf(this.abbreviations.get((int)i).factor));
            pos.setIndex(start + prefix.length());
            break;
        }
        return value;
    }

    private static List<AbbreviatedScale> abbreviationsForLocale(Locale locale) {
        Locale tmp = locale;
        do {
            List<AbbreviatedScale> abbs;
            if ((abbs = ABBREVIATIONS.get(tmp)) == null) continue;
            return abbs;
        } while ((tmp = LocaleUtil.parent((Locale)tmp)) != null);
        throw new UnsupportedOperationException("Locale not supported: " + locale);
    }

    static {
        AbbreviatedNumberFormat.createAbbreviation("Mrd", new Double(1.0E9), Locale.GERMAN);
        AbbreviatedNumberFormat.createAbbreviation("Mrd.", new Double(1.0E9), Locale.GERMAN);
        AbbreviatedNumberFormat.createAbbreviation("Mio", new Double(1000000.0), Locale.GERMAN);
        AbbreviatedNumberFormat.createAbbreviation("Mio.", new Double(1000000.0), Locale.GERMAN);
        AbbreviatedNumberFormat.createAbbreviation("Tsd", new Double(1000.0), Locale.GERMAN);
        AbbreviatedNumberFormat.createAbbreviation("Tsd.", new Double(1000.0), Locale.GERMAN);
        AbbreviatedNumberFormat.createAbbreviation("T", new Double(1000.0), Locale.GERMAN);
        AbbreviatedNumberFormat.createAbbreviation("Tsd", new Double(1000.0), Locale.ENGLISH);
        AbbreviatedNumberFormat.createAbbreviation("T", new Double(1.0E12), Locale.ENGLISH);
        AbbreviatedNumberFormat.createAbbreviation("B", new Double(1.0E9), Locale.ENGLISH);
        AbbreviatedNumberFormat.createAbbreviation("M", new Double(1000000.0), Locale.ENGLISH);
        AbbreviatedNumberFormat.createAbbreviation("K", new Double(1000.0), Locale.ENGLISH);
    }

    private static class AbbreviatedScale {
        public String code;
        public double factor;

        public AbbreviatedScale(String code, double factor) {
            this.code = code;
            this.factor = factor;
        }
    }
}

