/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.text;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.databene.commons.ConfigurationError;
import org.databene.commons.converter.ThreadSafeConverter;
import org.databene.formats.DataContainer;
import org.databene.formats.csv.CSVLineIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelocalizingConverter
extends ThreadSafeConverter<String, String> {
    private static final String CONFIG_FILENAME = "org/databene/formats/text/DelocalizingConverter.csv";
    private static Logger logger = LoggerFactory.getLogger(DelocalizingConverter.class);
    private Map<Character, String> replacements;

    public DelocalizingConverter() throws IOException {
        super(String.class, String.class);
        this.init();
    }

    public String convert(String source) {
        String product = source;
        for (Map.Entry<Character, String> entry : this.replacements.entrySet()) {
            product = product.replace(String.valueOf(entry.getKey()), entry.getValue());
        }
        return product;
    }

    private void init() throws IOException {
        this.replacements = new HashMap<Character, String>();
        CSVLineIterator iterator = new CSVLineIterator(CONFIG_FILENAME, ',', true, "UTF-8");
        DataContainer<String[]> tokens = new DataContainer<String[]>();
        while ((tokens = iterator.next(tokens)) != null) {
            this.addReplacements(tokens.getData());
        }
    }

    private void addReplacements(String[] tokens) {
        if (tokens.length < 2) {
            throw new ConfigurationError("At least two tokens needed to define a replacement");
        }
        String replacement = tokens[tokens.length - 1];
        for (int i = 0; i < tokens.length - 1; ++i) {
            String token = tokens[i];
            if (token.length() != 1) {
                throw new ConfigurationError("Source token length must be 1, wrong for token: " + token);
            }
            this.addReplacement(token.charAt(0), replacement);
        }
    }

    private void addReplacement(char original, String replacement) {
        String preset = this.replacements.get(Character.valueOf(original));
        if (preset != null) {
            if (preset.equals(replacement)) {
                logger.warn("double definition of replacement: " + original + " -> " + replacement);
            } else {
                logger.error("ambiguous definition of replacement: " + original + " -> " + replacement + " / " + preset);
            }
        }
        this.replacements.put(Character.valueOf(original), replacement);
    }
}

