/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.text;

import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.databene.commons.ArrayUtil;

public class KiloFormatter {
    public static final int BASE_1000 = 1000;
    public static final int BASE_1024 = 1024;
    public static final int DEFAULT_BASE = 1000;
    public static final String[] SYMBOLS = new String[]{"", "K", "M", "G", "T", "E"};
    private int base;
    private char decimalSeparator;

    public KiloFormatter(int base) {
        this(base, Locale.getDefault());
    }

    public KiloFormatter(int base, Locale locale) {
        this.base = base;
        DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(locale);
        this.decimalSeparator = symbols.getDecimalSeparator();
    }

    public String format(long value) {
        return this.convert(value, this.base);
    }

    public String convert(long value, int base) {
        long threshold = 1L;
        for (int i = 0; i < SYMBOLS.length; ++i) {
            if (value < threshold * (long)base) {
                return this.formatNumber(value, threshold, SYMBOLS[i]);
            }
            threshold *= (long)base;
        }
        return this.formatNumber(value, threshold / (long)base, (String)ArrayUtil.lastElementOf((Object[])SYMBOLS));
    }

    private String formatNumber(long value, long threshold, String symbol) {
        long prefix = value / threshold;
        long postfix = (value - prefix * threshold + threshold / 20L) * 10L / threshold;
        if (postfix >= 10L) {
            ++prefix;
            postfix -= 10L;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(prefix);
        if (postfix != 0L && prefix / 10L == 0L) {
            builder.append(this.decimalSeparator).append(postfix);
        }
        if (symbol.length() > 0) {
            builder.append(' ').append(symbol);
        }
        return builder.toString();
    }
}

