/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.text;

import java.text.MessageFormat;
import org.databene.commons.ConversionException;
import org.databene.commons.StringUtil;
import org.databene.commons.converter.ThreadSafeConverter;

public class ToHexConverter
extends ThreadSafeConverter<Object, String> {
    private boolean upperCase;
    private String pattern;
    private int length;

    public ToHexConverter() {
        this(false);
    }

    public ToHexConverter(boolean upperCase) {
        this(upperCase, null);
    }

    public ToHexConverter(boolean upperCase, String pattern) {
        this(upperCase, pattern, -1);
    }

    public ToHexConverter(boolean upperCase, String pattern, int length) {
        super(Object.class, String.class);
        this.upperCase = upperCase;
        this.pattern = pattern;
        this.length = length;
    }

    public String convert(Object sourceValue) throws ConversionException {
        if (sourceValue == null) {
            return null;
        }
        Class<?> sourceType = sourceValue.getClass();
        if (sourceType == Long.class) {
            return ToHexConverter.convertLong((Long)sourceValue, this.upperCase, this.pattern, this.length);
        }
        if (sourceType == Integer.class) {
            return ToHexConverter.convertInt((Integer)sourceValue, this.upperCase, this.pattern, this.length);
        }
        if (sourceType == Short.class) {
            return ToHexConverter.convertShort((Short)sourceValue, this.upperCase, this.pattern, this.length);
        }
        if (sourceType == Byte.class) {
            return ToHexConverter.convertByte((Byte)sourceValue, this.upperCase, this.pattern, this.length);
        }
        if (sourceType == Character.class) {
            return ToHexConverter.convertChar((Character)sourceValue, this.upperCase, this.pattern, this.length);
        }
        if (sourceType == String.class) {
            return ToHexConverter.convertString((String)sourceValue, this.upperCase, this.pattern, this.length);
        }
        throw new IllegalArgumentException("Can't render '" + sourceType + "' in hex format.");
    }

    public static String convertLong(Long sourceValue, boolean upperCase, String pattern, int length) {
        String base = Long.toHexString(sourceValue);
        return ToHexConverter.postProcess(base, upperCase, pattern, length);
    }

    public static String convertInt(int sourceValue, boolean upperCase, String pattern, int length) {
        String base = Integer.toHexString(sourceValue);
        return ToHexConverter.postProcess(base, upperCase, pattern, length);
    }

    public static String convertShort(short sourceValue, boolean upperCase, String pattern, int length) {
        String base = Integer.toHexString(sourceValue);
        if (base.length() == 8) {
            base = base.substring(4);
        }
        return ToHexConverter.postProcess(base, upperCase, pattern, length);
    }

    public static String convertByte(byte sourceValue, boolean upperCase, String pattern, int length) {
        String base = Integer.toHexString(sourceValue);
        if (base.length() == 8) {
            base = base.substring(6);
        }
        return ToHexConverter.postProcess(base, upperCase, pattern, length);
    }

    public static String convertChar(Character sourceValue, boolean upperCase, String pattern, int length) {
        String base = ToHexConverter.convertInt(sourceValue.charValue(), upperCase, null, 2);
        return ToHexConverter.postProcess(base, upperCase, pattern, length);
    }

    public static String convertString(String sourceValue, boolean upperCase, String pattern, int length) {
        StringBuilder builder = new StringBuilder(sourceValue.length() * 2);
        for (int i = 0; i < sourceValue.length(); ++i) {
            builder.append(ToHexConverter.convertChar(Character.valueOf(sourceValue.charAt(i)), upperCase, null, 2));
        }
        return ToHexConverter.postProcess(builder.toString(), upperCase, pattern, length);
    }

    private static String postProcess(String base, boolean upperCase, String pattern, int length) {
        if (upperCase) {
            base = base.toUpperCase();
        }
        if (length > 0) {
            base = StringUtil.padLeft((String)base, (int)length, (char)'0');
        }
        if (pattern != null) {
            base = MessageFormat.format(pattern, base);
        }
        return base;
    }
}

