/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.token;

import org.databene.commons.Assert;
import org.databene.formats.token.TextFragment;

public class Token<E extends Enum<E>>
implements TextFragment {
    private E type;
    private int startOffset;
    private int endOffset;

    public Token(E type, int startOffset, int endOffset) {
        Assert.notNull(type, (String)"tokenType");
        Assert.notNegative((Number)startOffset, (String)"startOffset");
        Assert.that((startOffset <= endOffset ? 1 : 0) != 0, (String)"startOffset is greater that endOffset");
        this.type = type;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    public E getType() {
        return this.type;
    }

    @Override
    public int getStartOffset() {
        return this.startOffset;
    }

    @Override
    public int getEndOffset() {
        return this.endOffset;
    }

    public void move(int offset) {
        this.startOffset += offset;
        this.endOffset += offset;
    }

    public int hashCode() {
        return 31 * (31 * this.endOffset + this.startOffset) + ((Enum)this.type).hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Token that = (Token)object;
        return this.type == that.getType() && this.endOffset == that.getEndOffset() && this.startOffset == that.getStartOffset();
    }

    public String toString() {
        return this.type + "(" + this.startOffset + "," + this.endOffset + ")";
    }
}

