/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.util;

import java.io.Closeable;
import org.databene.commons.Converter;
import org.databene.commons.IOUtil;
import org.databene.formats.DataContainer;
import org.databene.formats.DataIterator;
import org.databene.formats.util.DataIteratorAdapter;

public class ConvertingDataIterator<S, T>
extends DataIteratorAdapter<S, T> {
    protected Converter<S, T> converter;

    public ConvertingDataIterator(DataIterator<S> source, Converter<S, T> converter) {
        super(source);
        this.converter = converter;
    }

    @Override
    public Class<T> getType() {
        return this.converter.getTargetType();
    }

    @Override
    public DataContainer<T> next(DataContainer<T> container) {
        DataContainer sourceWrapper = this.nextOfSource();
        if (sourceWrapper == null) {
            return null;
        }
        return container.setData(this.converter.convert(sourceWrapper.getData()));
    }

    @Override
    public void close() {
        if (this.converter instanceof Closeable) {
            IOUtil.close((Closeable)((Closeable)this.converter));
        }
        super.close();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[source:" + this.source + ", converter:" + this.converter + "]";
    }
}

