/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.util;

import java.io.Closeable;
import java.io.IOException;
import org.databene.commons.IOUtil;
import org.databene.formats.DataContainer;
import org.databene.formats.DataIterator;
import org.databene.formats.util.DataIteratorProxy;

public class CyclicDataIterator<E>
extends DataIteratorProxy<E> {
    protected Creator<E> creator;

    public CyclicDataIterator(Creator<E> creator) throws IOException {
        super(creator.create());
        this.creator = creator;
    }

    @Override
    public synchronized DataContainer<E> next(DataContainer<E> wrapper) {
        DataContainer<E> result = super.next(wrapper);
        if (result == null) {
            this.reset();
            result = super.next(wrapper);
        }
        return result;
    }

    public synchronized void reset() {
        IOUtil.close((Closeable)this.source);
        try {
            this.source = this.creator.create();
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating DataIterator", e);
        }
    }

    public static interface Creator<E> {
        public DataIterator<E> create() throws IOException;
    }
}

