/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.util;

public class DataFileUtil {
    public static boolean isPlainTextDocument(String fileName) {
        return DataFileUtil.hasSuffixIgnoreCase(".txt", fileName);
    }

    public static boolean isDbUnitDocument(String fileName) {
        return DataFileUtil.hasSuffixIgnoreCase(".dbunit.xml", fileName);
    }

    public static boolean isXmlDocument(String fileName) {
        return DataFileUtil.hasSuffixIgnoreCase(".xml", fileName);
    }

    public static boolean isExcelOrCsvDocument(String fileName) {
        return DataFileUtil.isExcelDocument(fileName) || DataFileUtil.isCsvDocument(fileName);
    }

    public static boolean isExcelDocument(String fileName) {
        return DataFileUtil.isBinaryExcelDocument(fileName) || DataFileUtil.isXmlExcelDocument(fileName);
    }

    public static boolean isBinaryExcelDocument(String fileName) {
        return DataFileUtil.hasSuffixIgnoreCase(".xls", fileName);
    }

    public static boolean isXmlExcelDocument(String fileName) {
        return DataFileUtil.hasSuffixIgnoreCase(".xlsx", fileName);
    }

    public static boolean isCsvDocument(String fileName) {
        return DataFileUtil.hasSuffixIgnoreCase(".csv", fileName);
    }

    public static boolean isFixedColumnWidthFile(String fileName) {
        return DataFileUtil.hasSuffixIgnoreCase(".fcw", fileName);
    }

    public static boolean hasSuffixIgnoreCase(String suffix, String fileName) {
        return fileName.toLowerCase().endsWith(suffix);
    }
}

