/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.util;

import java.util.HashSet;
import org.databene.formats.DataContainer;
import org.databene.formats.DataIterator;

public abstract class DataIteratorTestCase {
    public static <T> void checkUniqueIteration(DataIterator<T> iterator, int count) {
        HashSet<T> items = new HashSet<T>(count);
        for (int i = 0; i < count; ++i) {
            T item = iterator.next(new DataContainer()).getData();
            assert (items.contains(item));
            items.add(item);
        }
    }

    public static <T> NextHelper expectNextElements(DataIterator<?> iterator, T ... expectedValues) {
        for (T expectedValue : expectedValues) {
            Object actualValue = iterator.next(new DataContainer()).getData();
            assert (expectedValue.equals(actualValue));
        }
        return new NextHelper(iterator);
    }

    protected static void expectUnavailable(DataIterator<?> iterator) {
        assert (iterator.next(new DataContainer()) == null);
    }

    public static class NextHelper {
        DataIterator<?> iterator;

        public NextHelper(DataIterator<?> iterator) {
            this.iterator = iterator;
        }

        public void withNext() {
            assert (this.iterator.next(new DataContainer()) != null);
        }

        public void withNoNext() {
            DataIteratorTestCase.expectUnavailable(this.iterator);
        }
    }
}

