/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.util;

import org.databene.commons.HeavyweightIterator;
import org.databene.commons.IOUtil;
import org.databene.formats.DataContainer;
import org.databene.formats.DataIterator;

public class JavaIteratorFromDataIterator<E>
implements HeavyweightIterator<E> {
    private DataIterator<E> source;
    private DataContainer<E> next;
    private boolean initialized;

    public JavaIteratorFromDataIterator(DataIterator<E> source) {
        this.source = source;
        this.next = new DataContainer();
        this.initialized = false;
    }

    public boolean hasNext() {
        if (!this.initialized) {
            this.next = this.source.next(this.next);
            this.initialized = true;
        }
        return this.next != null;
    }

    public E next() {
        if (!this.hasNext()) {
            throw new IllegalStateException("Not available. Check hasNext() before calling next()");
        }
        E result = this.next.getData();
        this.next = this.source.next(this.next);
        if (this.next == null) {
            this.close();
        }
        return result;
    }

    public void remove() {
        throw new UnsupportedOperationException("Iterator<E>.remove() is not supported");
    }

    public void close() {
        IOUtil.close(this.source);
        this.source = null;
    }

    public String toString() {
        return this.source.toString();
    }
}

