/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.util;

import java.util.ArrayList;
import java.util.List;
import org.databene.commons.CollectionUtil;
import org.databene.formats.DataContainer;
import org.databene.formats.DataIterator;

public class ListDataIterator<E>
implements DataIterator<E> {
    private Class<E> type;
    private List<E> data;
    private int cursor;

    public ListDataIterator(Class<E> type, E ... data) {
        this(type, CollectionUtil.toList((Object[])data));
    }

    public ListDataIterator(Class<E> type, List<E> data) {
        this.type = type;
        this.data = data != null ? data : new ArrayList();
        this.cursor = 0;
    }

    @Override
    public Class<E> getType() {
        return this.type;
    }

    @Override
    public DataContainer<E> next(DataContainer<E> container) {
        if (this.cursor >= this.data.size()) {
            return null;
        }
        return container.setData(this.data.get(this.cursor++));
    }

    @Override
    public void close() {
    }
}

