/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.util;

import java.util.ArrayList;
import java.util.List;
import org.databene.commons.ArrayUtil;
import org.databene.formats.DataContainer;
import org.databene.formats.DataIterator;

public class OrthogonalArrayIterator<E>
implements DataIterator<E[]> {
    private DataIterator<E[]> source;
    private List<E[]> rows;
    private int columnIndex;

    public OrthogonalArrayIterator(DataIterator<E[]> source) {
        this.source = source;
    }

    @Override
    public Class<E[]> getType() {
        return this.source.getType();
    }

    @Override
    public DataContainer<E[]> next(DataContainer<E[]> container) {
        this.beInitialized(container);
        if (this.rows.size() == 0 || this.columnIndex >= this.rows.get(0).length) {
            return null;
        }
        Object[] column = ArrayUtil.newInstance(this.source.getType().getComponentType(), (int)this.rows.size());
        for (int rowIndex = 0; rowIndex < this.rows.size(); ++rowIndex) {
            E[] row = this.rows.get(rowIndex);
            column[rowIndex] = this.columnIndex < row.length ? row[this.columnIndex] : null;
        }
        ++this.columnIndex;
        return container.setData(column);
    }

    @Override
    public void close() {
    }

    private void beInitialized(DataContainer<E[]> container) {
        if (this.rows == null) {
            this.rows = new ArrayList<E[]>();
            while (this.source.next(container) != null) {
                this.rows.add(container.getData());
            }
            this.columnIndex = 0;
        }
    }
}

