/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.xls;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Workbook;
import org.databene.commons.ConfigurationError;
import org.databene.commons.IOUtil;
import org.databene.commons.bean.PropertyGraphAccessor;
import org.databene.commons.converter.ToStringConverter;
import org.databene.formats.xls.PropFormat;
import org.databene.formats.xls.XLSUtil;

public class BeanXLSWriter<E>
implements Closeable {
    private final OutputStream out;
    private String sheetName;
    private List<PropFormat> beanProperties;
    private HSSFWorkbook workbook;

    public BeanXLSWriter(OutputStream out, String sheetName) {
        this(out, sheetName, null);
    }

    public BeanXLSWriter(OutputStream out, String sheetName, List<PropFormat> beanProperties) {
        this.out = out;
        this.sheetName = sheetName;
        this.beanProperties = beanProperties != null ? new ArrayList<PropFormat>(beanProperties) : new ArrayList();
    }

    public void addProperty(PropFormat property) {
        this.beanProperties.add(property);
    }

    public void save(E bean) {
        HSSFSheet sheet = this.getOrCreateSheet(bean, this.sheetName);
        HSSFRow row = sheet.createRow(sheet.getLastRowNum() + 1);
        for (int i = 0; i < this.beanProperties.size(); ++i) {
            PropFormat prop = this.beanProperties.get(i);
            Object propValue = PropertyGraphAccessor.getPropertyGraph((String)prop.getName(), bean);
            BeanXLSWriter.render(propValue, row, i);
        }
    }

    @Override
    public void close() {
        try {
            if (this.workbook == null) {
                this.workbook = new HSSFWorkbook();
            } else {
                XLSUtil.autoSizeColumns((Workbook)this.workbook);
            }
            this.workbook.write(this.out);
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationError((Throwable)e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtil.close((Closeable)this.out);
        }
    }

    private HSSFSheet getOrCreateSheet(E bean, String sheetName) {
        HSSFSheet sheet;
        if (this.workbook == null) {
            this.createWorkbook();
        }
        if ((sheet = this.workbook.getSheet(sheetName)) == null) {
            sheet = this.workbook.createSheet(sheetName);
            this.writeHeaderRow(bean, sheet);
        }
        return sheet;
    }

    private void createWorkbook() {
        this.workbook = new HSSFWorkbook();
    }

    private void writeHeaderRow(E bean, HSSFSheet sheet) {
        HSSFRow headerRow = sheet.createRow(0);
        for (int i = 0; i < this.beanProperties.size(); ++i) {
            PropFormat prop = this.beanProperties.get(i);
            String componentName = prop.getName();
            headerRow.createCell(i).setCellValue((RichTextString)new HSSFRichTextString(componentName));
            if (prop.getPattern() == null) continue;
            HSSFDataFormat dataFormat = this.workbook.createDataFormat();
            HSSFCellStyle columnStyle = this.workbook.createCellStyle();
            columnStyle.setDataFormat(dataFormat.getFormat(prop.getPattern()));
            sheet.setDefaultColumnStyle(i, (CellStyle)columnStyle);
        }
    }

    private static void render(Object propValue, HSSFRow row, int column) {
        HSSFCell cell = row.createCell(column);
        if (propValue instanceof Number) {
            cell.setCellValue(((Number)propValue).doubleValue());
        } else if (propValue instanceof Date) {
            cell.setCellValue((Date)propValue);
        } else if (propValue instanceof Boolean) {
            cell.setCellValue(((Boolean)propValue).booleanValue());
        } else {
            String s = ToStringConverter.convert((Object)propValue, null);
            cell.setCellValue((RichTextString)new HSSFRichTextString(s));
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

