/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.xls;

public class PropFormat {
    private String name;
    private String pattern;

    public PropFormat(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getPattern() {
        return this.pattern;
    }

    public PropFormat withDateFormat() {
        return this.withPattern("dd.MM.yyyy");
    }

    public PropFormat withIntFormat() {
        return this.withPattern("#,##0");
    }

    public PropFormat withPercentageFormat() {
        return this.withPattern("0%");
    }

    public PropFormat withDecimalFormat(int fractionDigits) {
        String pattern;
        switch (fractionDigits) {
            case 0: {
                pattern = "#,##0";
                break;
            }
            case 1: {
                pattern = "#,##0.0";
                break;
            }
            case 2: {
                pattern = "#,##0.00";
                break;
            }
            case 3: {
                pattern = "#,##0.000";
                break;
            }
            default: {
                StringBuilder builder = new StringBuilder("#,##0.");
                for (int i = 0; i < fractionDigits; ++i) {
                    builder.append("0");
                }
                pattern = builder.toString();
            }
        }
        return this.withPattern(pattern);
    }

    public PropFormat withPattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    public String toString() {
        return this.name + (this.pattern != null ? "[" + this.pattern + "]" : "");
    }
}

