/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.xls;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.databene.commons.Assert;
import org.databene.commons.Consumer;
import org.databene.commons.IOUtil;
import org.databene.formats.DataContainer;
import org.databene.formats.xls.BeanXLSWriter;
import org.databene.formats.xls.PropFormat;
import org.databene.formats.xls.XLSJavaBeanIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XLSBeanPersistor<E> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private Class<E> beanClass;
    private List<PropFormat> beanProperties;

    public XLSBeanPersistor(Class<E> beanClass, String ... propertyNames) {
        this.beanClass = beanClass;
        this.beanProperties = new ArrayList<PropFormat>();
        for (String propertyName : propertyNames) {
            this.addProperty(propertyName);
        }
    }

    protected PropFormat addProperty(String name) {
        PropFormat propFormat = new PropFormat(name);
        this.beanProperties.add(propFormat);
        return propFormat;
    }

    protected void load(File file, Consumer<E> consumer) throws FileNotFoundException, IOException, InvalidFormatException {
        XLSJavaBeanIterator mapper = new XLSJavaBeanIterator(file.getAbsolutePath(), null, false, this.beanClass);
        DataContainer wrapper = new DataContainer();
        while (mapper.next(wrapper) != null) {
            if (wrapper.getData() == null) continue;
            consumer.consume(wrapper.getData());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void save(File file, String sheetName, Iterator<E> beanIterator) throws IOException {
        Assert.notNull((Object)file, (String)"file");
        Assert.notNull((Object)sheetName, (String)"sheetName");
        Assert.notNull(beanIterator, (String)"beanIterator");
        BeanXLSWriter<E> out = null;
        try {
            out = new BeanXLSWriter<E>(new FileOutputStream(file), sheetName, this.beanProperties);
            while (beanIterator.hasNext()) {
                out.save(beanIterator.next());
            }
        }
        finally {
            IOUtil.close(out);
        }
    }
}

