/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.xls;

import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.databene.commons.ArrayUtil;
import org.databene.commons.Assert;
import org.databene.commons.BeanUtil;
import org.databene.commons.ConfigurationError;
import org.databene.commons.Context;
import org.databene.commons.Converter;
import org.databene.commons.StringUtil;
import org.databene.commons.context.DefaultContext;
import org.databene.commons.converter.PropertyArray2JavaBeanConverter;
import org.databene.commons.converter.util.ClassProvider;
import org.databene.commons.converter.util.ConstantClassProvider;
import org.databene.commons.converter.util.ReferenceResolver;
import org.databene.formats.DataContainer;
import org.databene.formats.script.ScriptConverterForStrings;
import org.databene.formats.util.ConvertingDataIterator;
import org.databene.formats.xls.XLSLineIterator;

public class XLSJavaBeanIterator<E>
extends ConvertingDataIterator<Object[], E> {
    private String uri;
    private boolean formatted;

    public XLSJavaBeanIterator(String uri, String sheetName, boolean formatted, Class<?> beanClass) throws IOException, InvalidFormatException {
        this(uri, sheetName, formatted, null, "", (ClassProvider<Object>)new ConstantClassProvider(beanClass));
    }

    public XLSJavaBeanIterator(String uri, String sheetName, boolean formatted, String nullMarker, String emptyMarker, ClassProvider<Object> beanClassProvider) throws IOException, InvalidFormatException {
        super(null, null);
        this.uri = uri;
        this.formatted = formatted;
        ScriptConverterForStrings scriptConverter = new ScriptConverterForStrings((Context)new DefaultContext());
        XLSLineIterator iterator = new XLSLineIterator(uri, sheetName, true, formatted, (Converter<String, ?>)scriptConverter);
        iterator.setNullMarker(nullMarker);
        iterator.setEmptyMarker(emptyMarker);
        String[] headers = XLSJavaBeanIterator.parseHeaders(uri, sheetName, iterator);
        this.source = iterator;
        this.converter = new PropertyArray2JavaBeanConverter(beanClassProvider, headers, (ReferenceResolver)new RefResolver());
    }

    public static <T> List<T> parseAll(String uri, String sheetName, boolean formatted, Class<T> type) throws InvalidFormatException, IOException {
        XLSJavaBeanIterator iterator = new XLSJavaBeanIterator(uri, sheetName, formatted, type);
        ArrayList result = new ArrayList();
        DataContainer container = new DataContainer();
        while (iterator.next(container) != null) {
            result.add(container.getData());
        }
        return result;
    }

    public static Class<?> getFeatureComponentType(Class<?> ownerClass, String featureName) {
        PropertyDescriptor propertyDescriptor = BeanUtil.getPropertyDescriptor(ownerClass, (String)featureName);
        if (propertyDescriptor != null) {
            Method readMethod = propertyDescriptor.getReadMethod();
            Class<?> returnType = readMethod.getReturnType();
            if (Collection.class.isAssignableFrom(returnType)) {
                ParameterizedType genericReturnType = (ParameterizedType)readMethod.getGenericReturnType();
                Type componentType = genericReturnType.getActualTypeArguments()[0];
                return (Class)componentType;
            }
            return returnType;
        }
        Field field = BeanUtil.getField(ownerClass, (String)featureName);
        if (field != null) {
            if (Collection.class.isAssignableFrom(field.getType())) {
                ParameterizedType genericReturnType = (ParameterizedType)field.getGenericType();
                Type componentType = genericReturnType.getActualTypeArguments()[0];
                return (Class)componentType;
            }
            return field.getType();
        }
        throw new ConfigurationError("Feature '" + featureName + "' not found in class " + ownerClass.getName());
    }

    private static String[] parseHeaders(String uri, String sheetName, XLSLineIterator iterator) {
        int headerCount;
        Object[] headers = iterator.getHeaders();
        Assert.notEmpty((Object[])headers, (String)("Empty XLS sheet '" + sheetName + "' in document " + uri));
        for (int i = 0; i < headers.length; ++i) {
            headers[i] = StringUtil.trimmedEmptyToNull((String)headers[i]);
        }
        for (headerCount = headers.length; headers[headerCount - 1] == null && headerCount > 0; --headerCount) {
        }
        if (headerCount == 0) {
            throw new IllegalArgumentException("No headers in XLS sheet '" + sheetName + "' of document " + uri);
        }
        for (int i = 0; i < headerCount; ++i) {
            Assert.notNull((Object)headers[i], (String)("Empty header in column #" + i + " of sheet '" + sheetName + "' of file '" + uri + "'"));
        }
        return (String[])ArrayUtil.copyOfRange((Object[])headers, (int)0, (int)headerCount);
    }

    class RefResolver
    implements ReferenceResolver {
        RefResolver() {
        }

        public Object resolveReferences(Object value, Object target, String localFeatureName) {
            String text;
            if (value instanceof String && (text = (String)value).startsWith("tab:")) {
                String targetSheetName = text.substring("tab:".length());
                try {
                    Class<?> targetType = XLSJavaBeanIterator.getFeatureComponentType(target.getClass(), localFeatureName);
                    return XLSJavaBeanIterator.parseAll(XLSJavaBeanIterator.this.uri, targetSheetName, XLSJavaBeanIterator.this.formatted, targetType);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error parsing XLS sheet '" + targetSheetName + "' of " + XLSJavaBeanIterator.this.uri, e);
                }
            }
            return value;
        }
    }
}

