/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.xls;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.databene.commons.Converter;
import org.databene.commons.IOUtil;
import org.databene.commons.ObjectNotFoundException;
import org.databene.commons.ParseException;
import org.databene.commons.StringUtil;
import org.databene.commons.converter.ArrayTypeConverter;
import org.databene.commons.converter.NoOpConverter;
import org.databene.formats.DataContainer;
import org.databene.formats.DataIterator;
import org.databene.formats.xls.XLSUtil;

public class XLSLineIterator
implements DataIterator<Object[]> {
    private String emptyMarker = "'";
    private String nullMarker = null;
    private boolean formatted;
    private Converter<String, ?> stringPreprocessor;
    private String[] headers;
    private Iterator<Row> rowIterator;

    public XLSLineIterator(String uri) throws IOException, ParseException {
        this(uri, 0);
    }

    public XLSLineIterator(String uri, int sheetIndex) throws IOException, ParseException {
        this(uri, sheetIndex, false, false, null);
    }

    public XLSLineIterator(String uri, int sheetIndex, boolean headersIncluded, boolean formatted, Converter<String, ?> stringPreprocessor) throws IOException, ParseException {
        this(XLSLineIterator.sheet(uri, sheetIndex), headersIncluded, formatted, stringPreprocessor);
    }

    public XLSLineIterator(String uri, String sheetName, boolean headersIncluded, boolean formatted) throws IOException, ParseException {
        this(uri, sheetName, headersIncluded, formatted, null);
    }

    public XLSLineIterator(String uri, String sheetName, boolean headersIncluded, boolean formatted, Converter<String, ?> stringPreprocessor) throws IOException, ParseException {
        this(XLSLineIterator.sheet(uri, sheetName), headersIncluded, formatted, stringPreprocessor);
    }

    public XLSLineIterator(Sheet sheet, boolean headersIncluded, boolean formatted, Converter<String, ?> stringPreprocessor) {
        this.formatted = formatted;
        if (stringPreprocessor == null) {
            stringPreprocessor = new NoOpConverter();
        }
        this.stringPreprocessor = stringPreprocessor;
        this.rowIterator = sheet.rowIterator();
        if (!this.rowIterator.hasNext()) {
            this.close();
            return;
        }
        if (headersIncluded) {
            this.parseHeaders();
        }
    }

    public String getEmptyMarker() {
        return this.emptyMarker;
    }

    public void setEmptyMarker(String emptyMarker) {
        this.emptyMarker = emptyMarker;
    }

    public String getNullMarker() {
        return this.nullMarker;
    }

    public void setNullMarker(String nullMarker) {
        this.nullMarker = nullMarker;
    }

    public boolean isFormatted() {
        return this.formatted;
    }

    public void setFormatted(boolean formatted) {
        this.formatted = formatted;
    }

    public String[] getHeaders() {
        return this.headers;
    }

    public void setHeaders(String[] headers) {
        this.headers = headers;
    }

    @Override
    public Class<Object[]> getType() {
        return Object[].class;
    }

    @Override
    public synchronized DataContainer<Object[]> next(DataContainer<Object[]> wrapper) {
        if (this.rowIterator == null || !this.rowIterator.hasNext()) {
            return null;
        }
        Row row = this.rowIterator.next();
        int cellCount = row.getLastCellNum();
        Object[] result = new Object[cellCount];
        for (int cellnum = 0; cellnum < cellCount; ++cellnum) {
            result[cellnum] = this.formatted ? XLSUtil.resolveCellValueAsString(row.getCell(cellnum), this.emptyMarker, this.nullMarker, this.stringPreprocessor) : XLSUtil.resolveCellValue(row.getCell(cellnum), this.emptyMarker, this.nullMarker, this.stringPreprocessor);
        }
        return wrapper.setData(result);
    }

    public Object cellValueForHeader(String header, Object[] cells) {
        String trimmedHeader = StringUtil.trim((String)header);
        for (int i = 0; i < this.headers.length; ++i) {
            if (!this.headers[i].equals(trimmedHeader)) continue;
            return cells[i];
        }
        throw new ObjectNotFoundException("Undefined header: '" + trimmedHeader + "'");
    }

    @Override
    public synchronized void close() {
        this.rowIterator = null;
    }

    private static Sheet sheet(String uri, String sheetName) throws IOException, ParseException {
        try {
            Sheet sheet;
            Workbook workbook = WorkbookFactory.create((InputStream)IOUtil.getInputStreamForURI((String)uri));
            Sheet sheet2 = sheet = sheetName != null ? workbook.getSheet(sheetName) : workbook.getSheetAt(0);
            if (sheet == null) {
                throw new IllegalArgumentException("Sheet '" + sheetName + "' not found in file " + uri);
            }
            return sheet;
        }
        catch (InvalidFormatException e) {
            throw new ParseException("Error parsing sheet '" + sheetName + "' of " + uri, null);
        }
    }

    private static Sheet sheet(String uri, int sheetIndex) throws IOException {
        try {
            Workbook workbook = WorkbookFactory.create((InputStream)IOUtil.getInputStreamForURI((String)uri));
            return workbook.getSheetAt(sheetIndex);
        }
        catch (InvalidFormatException e) {
            throw new ParseException("Error parsing sheet " + sheetIndex + " of " + uri, (Throwable)e, null, -1, -1);
        }
    }

    private void parseHeaders() {
        DataContainer<Object[]> wrapper = new DataContainer<Object[]>();
        if (this.next(wrapper) != null) {
            this.headers = StringUtil.trimAll((String[])((String[])ArrayTypeConverter.convert((Object[])wrapper.getData(), String.class)));
        } else {
            this.headers = null;
            this.close();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.rowIterator + "]";
    }
}

