/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.xls;

import org.databene.formats.DataIterator;
import org.databene.formats.DataSource;
import org.databene.formats.util.OrthogonalArrayIterator;
import org.databene.formats.xls.XLSLineIterator;

public class XLSSource
implements DataSource<Object[]> {
    private String uri;
    private boolean formatted;
    private String emptyMarker;
    private String nullMarker;
    private boolean rowBased;

    public XLSSource(String uri, boolean formatted, String emptyMarker, String nullMarker, boolean rowBased) {
        this.uri = uri;
        this.formatted = formatted;
        this.emptyMarker = emptyMarker;
        this.nullMarker = nullMarker;
        this.rowBased = rowBased;
    }

    @Override
    public Class<Object[]> getType() {
        return Object[].class;
    }

    @Override
    public DataIterator<Object[]> iterator() {
        try {
            XLSLineIterator iterator = new XLSLineIterator(this.uri);
            iterator.setFormatted(this.formatted);
            if (this.emptyMarker != null) {
                iterator.setEmptyMarker(this.emptyMarker);
            }
            if (this.nullMarker != null) {
                iterator.setNullMarker(this.nullMarker);
            }
            if (!this.rowBased) {
                return new OrthogonalArrayIterator(iterator);
            }
            return iterator;
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating iterator for " + this.uri, e);
        }
    }

    @Override
    public void close() {
    }
}

