/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.xls;

import java.util.Iterator;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.databene.commons.ConfigurationError;
import org.databene.commons.Converter;
import org.databene.commons.MathUtil;
import org.databene.commons.converter.ToStringConverter;

public class XLSUtil {
    private XLSUtil() {
    }

    public static Object resolveCellValue(Cell cell) {
        return XLSUtil.resolveCellValue(cell, "'", null, null);
    }

    public static Object resolveCellValue(Cell cell, String emptyMarker, String nullMarker, Converter<String, ?> stringPreprocessor) {
        if (cell == null) {
            return null;
        }
        switch (cell.getCellType()) {
            case 1: {
                return XLSUtil.convertString(cell, emptyMarker, nullMarker, stringPreprocessor);
            }
            case 0: {
                if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                    return cell.getDateCellValue();
                }
                return XLSUtil.mapNumberType(cell.getNumericCellValue());
            }
            case 4: {
                return cell.getBooleanCellValue();
            }
            case 3: 
            case 5: {
                return cell.getRichStringCellValue().getString();
            }
            case 2: {
                FormulaEvaluator evaluator = XLSUtil.createFormulaEvaluator(cell);
                CellValue cellValue = evaluator.evaluate(cell);
                switch (cellValue.getCellType()) {
                    case 1: {
                        return XLSUtil.convertString(cellValue, emptyMarker, stringPreprocessor);
                    }
                    case 0: {
                        if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                            return HSSFDateUtil.getJavaDate((double)cellValue.getNumberValue());
                        }
                        return XLSUtil.mapNumberType(cellValue.getNumberValue());
                    }
                    case 4: {
                        return cellValue.getBooleanValue();
                    }
                    case 3: 
                    case 5: {
                        return null;
                    }
                }
                throw new IllegalStateException("Unexpected cell type: " + cellValue.getCellType());
            }
        }
        throw new ConfigurationError("Not a supported cell type: " + cell.getCellType());
    }

    public static String resolveCellValueAsString(Cell cell) {
        return XLSUtil.resolveCellValueAsString(cell, "'", null, null);
    }

    public static String resolveCellValueAsString(Cell cell, String emptyMarker, String nullMarker, Converter<String, ?> stringPreprocessor) {
        if (cell == null) {
            return null;
        }
        if (cell.getCellType() == 1) {
            String content = cell.getRichStringCellValue().getString();
            if (content != null) {
                if (content.equals(emptyMarker) || content.equals("'")) {
                    content = "";
                } else if (content.equals(nullMarker)) {
                    content = null;
                }
            }
            if (stringPreprocessor != null) {
                content = ToStringConverter.convert((Object)stringPreprocessor.convert((Object)content), null);
            }
            return content;
        }
        DataFormatter formatter = new DataFormatter();
        if (cell.getCellType() == 2) {
            return formatter.formatCellValue(cell, XLSUtil.createFormulaEvaluator(cell));
        }
        return formatter.formatCellValue(cell);
    }

    public static void autoSizeColumns(Workbook workbook) {
        int sheetCount = workbook.getNumberOfSheets();
        for (int i = 0; i < sheetCount; ++i) {
            Sheet sheet = workbook.getSheetAt(i);
            int firstRowNum = sheet.getFirstRowNum();
            if (firstRowNum < 0) continue;
            Row firstRow = sheet.getRow(firstRowNum);
            for (int cellnum = firstRow.getFirstCellNum(); cellnum < firstRow.getLastCellNum(); ++cellnum) {
                sheet.autoSizeColumn(cellnum);
            }
        }
    }

    public static boolean isEmpty(Row row) {
        if (row == null) {
            return true;
        }
        for (int i = 0; i < row.getLastCellNum(); ++i) {
            if (XLSUtil.isEmpty(row.getCell(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(Cell cell) {
        if (cell == null) {
            return true;
        }
        if (cell.getCellType() == 3) {
            return true;
        }
        if (cell.getCellType() == 1) {
            return cell.getStringCellValue().isEmpty();
        }
        return false;
    }

    private static FormulaEvaluator createFormulaEvaluator(Cell cell) {
        return cell.getSheet().getWorkbook().getCreationHelper().createFormulaEvaluator();
    }

    private static Number mapNumberType(double numericCellValue) {
        if (MathUtil.isIntegralValue((double)numericCellValue)) {
            return Double.valueOf(numericCellValue).longValue();
        }
        return numericCellValue;
    }

    private static Object convertString(CellValue cellValue, String emptyMarker, Converter<?, ?> stringPreprocessor) {
        String content = cellValue.getStringValue();
        if (content != null && (content.equals(emptyMarker) || content.equals("'"))) {
            content = "";
        }
        return stringPreprocessor != null ? stringPreprocessor.convert((Object)content) : content;
    }

    private static Object convertString(Cell cell, String emptyMarker, String nullMarker, Converter<?, ?> stringPreprocessor) {
        String content = cell.getRichStringCellValue().getString();
        if (content != null) {
            if (content.equals(emptyMarker) || content.equals("'")) {
                content = "";
            }
            if (content.equals(nullMarker)) {
                content = null;
            }
        }
        return stringPreprocessor != null ? stringPreprocessor.convert((Object)content) : content;
    }

    public static int getColumnCount(Sheet sheet) {
        int columnCount = 0;
        Iterator rowIterator = sheet.rowIterator();
        while (rowIterator.hasNext()) {
            columnCount = Math.max(columnCount, ((Row)rowIterator.next()).getLastCellNum());
        }
        return columnCount;
    }
}

