/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.xml;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.databene.commons.ArrayFormat;
import org.databene.commons.ArrayUtil;
import org.databene.commons.CollectionUtil;
import org.databene.commons.ConfigurationError;
import org.databene.commons.ParseUtil;
import org.databene.commons.StringUtil;
import org.databene.commons.SyntaxError;
import org.databene.commons.xml.XMLUtil;
import org.databene.formats.xml.ParseContext;
import org.databene.formats.xml.XMLElementParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public abstract class AbstractXMLElementParser<E>
implements XMLElementParser<E> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final String elementName;
    protected final Set<Class<?>> supportedParentTypes;
    protected Set<String> requiredAttributes;
    protected Set<String> optionalAttributes;

    public AbstractXMLElementParser(String elementName, Set<String> requiredAttributes, Set<String> optionalAttributes, Class<?> ... supportedParentTypes) {
        this.elementName = elementName;
        this.requiredAttributes = requiredAttributes != null ? requiredAttributes : Collections.emptySet();
        this.optionalAttributes = optionalAttributes != null ? optionalAttributes : Collections.emptySet();
        this.supportedParentTypes = CollectionUtil.toSet((Object[])supportedParentTypes);
    }

    @Override
    public boolean supports(Element element, E[] parentPath) {
        if (!this.elementName.equals(element.getNodeName())) {
            return false;
        }
        return CollectionUtil.isEmpty(this.supportedParentTypes) || parentPath == null || this.supportedParentTypes.contains(ArrayUtil.lastElementOf((Object[])parentPath).getClass());
    }

    @Override
    public final E parse(Element element, E[] parentPath, ParseContext<E> context) {
        this.checkAttributeSupport(element);
        return this.doParse(element, parentPath, context);
    }

    protected abstract E doParse(Element var1, E[] var2, ParseContext<E> var3);

    protected void checkAttributeSupport(Element element) {
        for (String attribute : XMLUtil.getAttributes((Element)element).keySet()) {
            if (this.requiredAttributes.contains(attribute) || this.optionalAttributes.contains(attribute)) continue;
            this.unsupportedAttribute(element, attribute);
        }
        for (String requiredAttribute : this.requiredAttributes) {
            if (!StringUtil.isEmpty((CharSequence)element.getAttribute(requiredAttribute))) continue;
            AbstractXMLElementParser.syntaxError("Required attribute '" + requiredAttribute + "' is missing", element);
        }
    }

    protected void checkSupportedAttributes(Element element, String ... supportedAttributes) {
        for (String actualAttribute : XMLUtil.getAttributes((Element)element).keySet()) {
            if (ArrayUtil.contains((Object)actualAttribute, (Object)supportedAttributes)) continue;
            this.unsupportedAttribute(element, actualAttribute);
        }
    }

    protected void assertElementName(String expectedName, Element element) {
        if (!element.getNodeName().equals(expectedName)) {
            throw new RuntimeException("Expected element name '" + expectedName + "', " + "found: '" + element.getNodeName());
        }
    }

    protected void excludeAttributes(Element element, String ... attributeNames) {
        String usedAttribute = null;
        for (String attributeName : attributeNames) {
            if (StringUtil.isEmpty((CharSequence)element.getAttribute(attributeName))) continue;
            if (usedAttribute == null) {
                usedAttribute = attributeName;
                continue;
            }
            AbstractXMLElementParser.syntaxError("The attributes '" + usedAttribute + "' and '" + attributeName + "' " + "exclude each other", element);
        }
    }

    protected void assertAtLeastOneAttributeIsSet(Element element, String ... attributeNames) {
        boolean ok = false;
        for (String attributeName : attributeNames) {
            if (StringUtil.isEmpty((CharSequence)element.getAttribute(attributeName))) continue;
            ok = true;
        }
        if (!ok) {
            throw AbstractXMLElementParser.createSyntaxError("At least one of these attributes must be set: " + ArrayFormat.format((Object[])attributeNames), element);
        }
    }

    protected void assertAttributeIsSet(Element element, String attributeName) {
        if (StringUtil.isEmpty((CharSequence)element.getAttribute(attributeName))) {
            throw AbstractXMLElementParser.createSyntaxError("Attribute '" + attributeName + "' is missing", element);
        }
    }

    protected void assertAttributeIsNotSet(Element element, String attributeName) {
        if (!StringUtil.isEmpty((CharSequence)element.getAttribute(attributeName))) {
            throw AbstractXMLElementParser.createSyntaxError("Attributes '" + attributeName + "' must not be set", element);
        }
    }

    protected Object parent(E[] parentPath) {
        if (ArrayUtil.isEmpty(parentPath)) {
            return null;
        }
        return ArrayUtil.lastElementOf((Object[])parentPath);
    }

    protected String parseRequiredName(Element element) {
        String name = this.parseOptionalName(element);
        if (StringUtil.isEmpty((CharSequence)name)) {
            throw AbstractXMLElementParser.createSyntaxError("'name' attribute is missing", element);
        }
        return name;
    }

    protected String parseOptionalName(Element element) {
        return this.getOptionalAttribute("name", element);
    }

    protected Integer parseOptionalInteger(String attributeName, Element element) {
        String spec = this.getOptionalAttribute(attributeName, element);
        return spec != null ? Integer.valueOf(Integer.parseInt(spec)) : null;
    }

    protected Boolean parseOptionalBoolean(String attributeName, Element element) {
        String spec = this.getOptionalAttribute(attributeName, element);
        return spec != null ? ParseUtil.parseBoolean((String)spec) : null;
    }

    protected Long parseOptionalLong(String attributeName, Element element) {
        String spec = this.getOptionalAttribute(attributeName, element);
        return spec != null ? Long.valueOf(Long.parseLong(spec)) : null;
    }

    public String getRequiredAttribute(String name, Element element) {
        String value = this.getOptionalAttribute(name, element);
        if (value == null) {
            AbstractXMLElementParser.syntaxError("'" + name + "' attribute expected", element);
        }
        return value;
    }

    protected String getOptionalAttribute(String name, Element element) {
        return StringUtil.emptyToNull((String)element.getAttribute(name));
    }

    protected void checkAttributes(Element element, Set<String> supportedAttributes) {
        for (Map.Entry attribute : XMLUtil.getAttributes((Element)element).entrySet()) {
            if (supportedAttributes.contains(attribute.getKey())) continue;
            throw new ConfigurationError("Not a supported import attribute: " + (String)attribute.getKey());
        }
    }

    protected static SyntaxError createSyntaxError(String message, Element element) {
        return new SyntaxError("Syntax error: " + message, XMLUtil.format((Element)element));
    }

    protected static SyntaxError createSyntaxError(String message, Element element, Exception cause) {
        return new SyntaxError("Syntax error: " + message, (Throwable)cause, XMLUtil.format((Element)element), -1, -1);
    }

    protected static void syntaxError(String message, Element element) {
        throw new SyntaxError("Syntax error: " + message, XMLUtil.format((Element)element));
    }

    private void unsupportedAttribute(Element element, String attribute) {
        StringBuilder message = this.renderUnsupportedAttributesMessage(attribute);
        throw AbstractXMLElementParser.createSyntaxError(message.toString(), element);
    }

    StringBuilder renderUnsupportedAttributesMessage(String attribute) {
        StringBuilder message = new StringBuilder("attribute '").append(attribute).append("' is not supported. ");
        message.append("The attributes supported by <" + this.elementName + "> are: ");
        boolean first = true;
        first = AbstractXMLElementParser.listAttributes(this.requiredAttributes, message, first);
        AbstractXMLElementParser.listAttributes(this.optionalAttributes, message, first);
        return message;
    }

    private static boolean listAttributes(Set<String> supportedAttributes, StringBuilder message, boolean first) {
        for (String supportedAttribute : supportedAttributes) {
            if (first) {
                first = false;
            } else {
                message.append(", ");
            }
            message.append(supportedAttribute);
        }
        return first;
    }

    protected void syntaxWarning(String message, Element element) {
        this.logger.warn("Syntax warning: " + message + " in " + XMLUtil.format((Element)element));
    }
}

