/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.databene.commons.ArrayUtil;
import org.databene.commons.Context;
import org.databene.commons.context.DefaultContext;
import org.databene.commons.xml.XMLUtil;
import org.databene.formats.xml.XMLElementParser;
import org.databene.formats.xml.XMLElementParserFactory;
import org.w3c.dom.Element;

public class ParseContext<E>
implements Context {
    protected XMLElementParserFactory<E> factory;
    protected Class<E> pathComponentType;
    private Context context;

    public ParseContext(Class<E> pathComponentType) {
        this(pathComponentType, new XMLElementParserFactory());
    }

    public ParseContext(Class<E> pathComponentType, XMLElementParserFactory<E> factory) {
        this.pathComponentType = pathComponentType;
        this.factory = factory;
        this.context = new DefaultContext();
    }

    public void addParser(XMLElementParser<E> parser) {
        this.factory.addParser(parser);
    }

    public E parseElement(Element element, E[] parentPath) {
        XMLElementParser<E> parser = this.factory.getParser(element, parentPath);
        return parser.parse(element, parentPath, this);
    }

    public List<E> parseChildElementsOf(Element element, E[] currentPath) {
        ArrayList<E> result = new ArrayList<E>();
        for (Element childElement : XMLUtil.getChildElements((Element)element)) {
            result.add(this.parseChildElement(childElement, currentPath));
        }
        return result;
    }

    public E parseChildElement(Element childElement, E[] currentPath) {
        return this.parseElement(childElement, currentPath);
    }

    public E[] createSubPath(E[] parentPath, E currentObject) {
        if (parentPath == null) {
            return ArrayUtil.buildObjectArrayOfType(this.pathComponentType, (Object[])new Object[]{currentObject});
        }
        return ArrayUtil.append(currentObject, (Object[])parentPath);
    }

    public Object get(String key) {
        return this.context.get(key);
    }

    public void set(String key, Object value) {
        this.context.set(key, value);
    }

    public void remove(String key) {
        this.context.remove(key);
    }

    public boolean contains(String key) {
        return this.context.contains(key);
    }

    public Set<String> keySet() {
        return this.context.keySet();
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        return this.context.entrySet();
    }
}

