/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.xml.compare;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.xpath.XPathExpressionException;
import org.databene.commons.NullSafeComparator;
import org.databene.commons.ProgrammerError;
import org.databene.commons.xml.XPathUtil;
import org.databene.formats.compare.DiffDetailType;
import org.databene.formats.compare.LocalDiffType;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ComparisonContext {
    private List<PathSetting> pathSettings;

    public ComparisonContext() {
        try {
            this.init(null, null, null);
        }
        catch (XPathExpressionException e) {
            throw new ProgrammerError((Throwable)e);
        }
    }

    public ComparisonContext(Set<LocalDiffType> toleratedDiffs, Document expectedDocument, Document actualDocument) throws XPathExpressionException {
        this.init(toleratedDiffs, expectedDocument, actualDocument);
    }

    private void init(Set<LocalDiffType> toleratedDiffs, Document expectedDocument, Document actualDocument) throws XPathExpressionException {
        this.pathSettings = new ArrayList<PathSetting>();
        if (toleratedDiffs != null) {
            for (LocalDiffType localDiffType : toleratedDiffs) {
                PathSetting pathSetting = new PathSetting(localDiffType.getLocator(), localDiffType.getType());
                pathSetting.collectAffectedNodes(expectedDocument);
                pathSetting.collectAffectedNodes(actualDocument);
                this.pathSettings.add(pathSetting);
            }
        }
    }

    public boolean isExcluded(Object node) {
        for (PathSetting pathSetting : this.pathSettings) {
            if (!pathSetting.isAffectedNode(node) || pathSetting.getDiffType() != null) continue;
            return true;
        }
        return false;
    }

    public boolean isTolerated(DiffDetailType type, Object expected, Object actual) {
        for (PathSetting pathSetting : this.pathSettings) {
            Object diffType = pathSetting.getDiffType();
            if (!pathSetting.isAffectedNode(expected) && !pathSetting.isAffectedNode(actual) || diffType != null && diffType != type) continue;
            return true;
        }
        return false;
    }

    public boolean isTolerated(DiffDetailType diffType, String locator) {
        for (PathSetting pathSetting : this.pathSettings) {
            if (!NullSafeComparator.equals((Object)locator, (Object)pathSetting.getLocator()) || pathSetting.getDiffType() != null && pathSetting.getDiffType() != diffType) continue;
            return true;
        }
        return false;
    }

    static class PathSetting {
        private final String locator;
        private final DiffDetailType diffType;
        private final List<Object> affectedNodes;

        private PathSetting(String locator, DiffDetailType type) {
            this.locator = locator;
            this.diffType = type;
            this.affectedNodes = new ArrayList<Object>();
        }

        public String getLocator() {
            return this.locator;
        }

        public Object getDiffType() {
            return this.diffType;
        }

        public boolean isAffectedNode(Object node) {
            if (this.locator == null) {
                return true;
            }
            for (Object affectedNode : this.affectedNodes) {
                if (node != affectedNode) continue;
                return true;
            }
            return false;
        }

        public void collectAffectedNodes(Document document) throws XPathExpressionException {
            if (this.locator != null && document != null) {
                NodeList foundNodes = XPathUtil.queryNodes((Node)document, (String)this.locator);
                for (int i = 0; i < foundNodes.getLength(); ++i) {
                    this.affectedNodes.add(foundNodes.item(i));
                }
            }
        }
    }
}

