/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.xml.compare;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.databene.commons.ArrayBuilder;
import org.databene.commons.ConfigurationError;
import org.databene.commons.NullSafeComparator;
import org.databene.commons.StringUtil;
import org.databene.commons.xml.XMLUtil;
import org.databene.commons.xml.XPathUtil;
import org.databene.formats.compare.KeyExpression;
import org.databene.formats.xml.compare.AbstractXMLComparisonModel;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DefaultXMLComparisonModel
extends AbstractXMLComparisonModel {
    private List<KeyExpression> keyExpressions = new ArrayList<KeyExpression>();
    private Map<Element, String> keys = new HashMap<Element, String>();
    private boolean initialized = false;

    @Override
    public void addKeyExpression(String locator, String keyExpression) {
        this.keyExpressions.add(new KeyExpression(locator, keyExpression));
    }

    @Override
    public List<KeyExpression> getKeyExpressions() {
        return this.keyExpressions;
    }

    @Override
    public void init(Document document1, Document document2) {
        try {
            this.keys.clear();
            for (KeyExpression keyExpression : this.keyExpressions) {
                if (document1 != null) {
                    List elements1 = XPathUtil.queryElements((Node)document1, (String)keyExpression.getLocator());
                    for (Element element : elements1) {
                        String key1 = XPathUtil.queryString((Node)element, (String)keyExpression.getExpression());
                        this.keys.put(element, key1);
                    }
                }
                if (document2 == null) continue;
                List elements2 = XPathUtil.queryElements((Node)document2, (String)keyExpression.getLocator());
                for (Element element : elements2) {
                    String key2 = XPathUtil.queryString((Node)element, (String)keyExpression.getExpression());
                    this.keys.put(element, key2);
                }
            }
            this.initialized = true;
        }
        catch (XPathExpressionException e) {
            this.keys.clear();
            throw new ConfigurationError("Error evaluating key expression", (Throwable)e);
        }
    }

    @Override
    public boolean equal(Object o1, Object o2) {
        this.assertInitialized();
        return this.equalNodes((Node)o1, (Node)o2);
    }

    @Override
    public boolean correspond(Object o1, Object o2) {
        this.assertInitialized();
        Node n1 = (Node)o1;
        Node n2 = (Node)o2;
        if (n1 instanceof Text && n2 instanceof Text) {
            return true;
        }
        if (n1 instanceof Element && n2 instanceof Element) {
            Element e1 = (Element)n1;
            Element e2 = (Element)n2;
            String ln1 = e1.getLocalName();
            String ln2 = e2.getLocalName();
            if (ln1 != null ? !ln1.equals(ln2) : ln2 != null) {
                return false;
            }
            String key1 = this.keys.get(e1);
            if (key1 == null) {
                return true;
            }
            return key1.equals(this.keys.get(e2));
        }
        return n1.getNodeName().equals(n2.getNodeName());
    }

    @Override
    public String subPath(Object[] array, int index) {
        this.assertInitialized();
        Node node = (Node)array[index];
        String name = DefaultXMLComparisonModel.name(node);
        if (name.length() == 0) {
            return "[" + (index + 1) + "]";
        }
        int nameOccurrences = 0;
        int indexAmongHomonyms = -1;
        for (int i = 0; i < array.length; ++i) {
            if (!DefaultXMLComparisonModel.name((Node)array[i]).equals(name)) continue;
            if (i == index) {
                indexAmongHomonyms = nameOccurrences;
            }
            ++nameOccurrences;
        }
        String result = "/" + name;
        if (nameOccurrences > 1) {
            result = result + "[" + (indexAmongHomonyms + 1) + "]";
        }
        return result;
    }

    public boolean equalNodes(Node n1, Node n2) {
        Node[] c2;
        Node[] c1;
        this.assertInitialized();
        if (n1 instanceof Element && n2 instanceof Element ? !this.elementNamesMatch((Element)n1, (Element)n2) : !n1.getNodeName().equals(n2.getNodeName())) {
            return false;
        }
        if (n1 instanceof Element) {
            if (n2 instanceof Element) {
                Element e1 = (Element)n1;
                Element e2 = (Element)n2;
                if (!XMLUtil.getAttributes((Element)e1).equals(XMLUtil.getAttributes((Element)e2))) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if ((c1 = this.childNodes(n1)).length != (c2 = this.childNodes(n2)).length) {
            return false;
        }
        for (int i = 0; i < c1.length; ++i) {
            if (this.equalNodes(c1[i], c2[i])) continue;
            return false;
        }
        return n1.getTextContent().equals(n2.getTextContent());
    }

    @Override
    public Node[] childNodes(Node parent) {
        this.assertInitialized();
        if (!(parent instanceof Element)) {
            return new Node[0];
        }
        NodeList childNodes = parent.getChildNodes();
        ArrayBuilder builder = new ArrayBuilder(Node.class);
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            if (child instanceof Element) {
                builder.add((Object)child);
                continue;
            }
            if (child instanceof ProcessingInstruction) {
                if (!this.processingInstructionRelevant) continue;
                builder.add((Object)child);
                continue;
            }
            if (child instanceof CDATASection) {
                if (this.cdataRelevant) {
                    builder.add((Object)child);
                    continue;
                }
                builder.add((Object)parent.getOwnerDocument().createTextNode(child.getTextContent()));
                continue;
            }
            if (child instanceof Text) {
                if (StringUtil.trim((String)child.getTextContent()).isEmpty()) {
                    if (!this.whitespaceRelevant) continue;
                    builder.add((Object)child);
                    continue;
                }
                builder.add((Object)child);
                continue;
            }
            if (child instanceof Comment) {
                if (!this.commentRelevant) continue;
                builder.add((Object)child);
                continue;
            }
            throw new UnsupportedOperationException("Unsupported node type: " + child.getClass().getName());
        }
        return (Node[])builder.toArray();
    }

    private void assertInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException(this.getClass().getName() + " is not initialized, call the init() method before using it");
        }
    }

    private boolean elementNamesMatch(Element e1, Element e2) {
        String ln1 = e1.getLocalName();
        String ln2 = e2.getLocalName();
        if (ln1 != null ? !ln1.equals(ln2) : ln2 != null) {
            return false;
        }
        return !this.namespaceRelevant || NullSafeComparator.equals((Object)e1.getNamespaceURI(), (Object)e2.getNamespaceURI());
    }

    private static String name(Node node) {
        if (node instanceof Text) {
            return "text()";
        }
        if (node instanceof Comment) {
            return "comment()";
        }
        return node.getNodeName();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [keyExpressions=" + this.keyExpressions + "]";
    }
}

