/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.xml.compare;

import java.io.IOException;
import java.util.Iterator;
import javax.xml.xpath.XPathExpressionException;
import org.databene.commons.Converter;
import org.databene.commons.NullSafeComparator;
import org.databene.commons.StringUtil;
import org.databene.commons.SystemInfo;
import org.databene.commons.converter.XMLNode2StringConverter;
import org.databene.commons.xml.XMLUtil;
import org.databene.formats.compare.AggregateDiff;
import org.databene.formats.compare.ArrayComparator;
import org.databene.formats.compare.ArrayComparisonResult;
import org.databene.formats.compare.DiffDetail;
import org.databene.formats.compare.DiffDetailType;
import org.databene.formats.compare.DiffFactory;
import org.databene.formats.xml.compare.ComparisonContext;
import org.databene.formats.xml.compare.XMLComparisonSettings;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class XMLComparator {
    private XMLComparisonSettings settings;
    private DiffFactory diffFactory;

    public XMLComparator() {
        this(new XMLComparisonSettings());
    }

    public XMLComparator(XMLComparisonSettings settings) {
        this.settings = settings;
        this.diffFactory = new DiffFactory((Converter<Object, String>)new XMLNode2StringConverter());
    }

    public void assertEquals(Document expected, Document actual) throws XPathExpressionException {
        AggregateDiff diffs = this.compare(expected, actual);
        if (diffs.getDetailCount() > 0) {
            String LF = SystemInfo.getLineSeparator();
            StringBuilder message = new StringBuilder("Documents do not match. Found " + diffs.getDetailCount() + " difference");
            if (diffs.getDetailCount() > 1) {
                message.append('s');
            }
            for (DiffDetail diff : diffs.getDetails()) {
                message.append(LF).append(diff);
            }
            throw new AssertionError(message);
        }
    }

    public AggregateDiff compare(String uriOfExpected, String uriOfActual) throws IOException, XPathExpressionException {
        Document expectedDoc = XMLUtil.parse((String)uriOfExpected);
        Document actualDoc = XMLUtil.parse((String)uriOfActual);
        return this.compare(expectedDoc, actualDoc);
    }

    public AggregateDiff compare(Document expectedDocument, Document actualDocument) throws XPathExpressionException {
        ComparisonContext context = new ComparisonContext(this.settings.getToleratedDiffs(), expectedDocument, actualDocument);
        this.settings.getModel().init(actualDocument, expectedDocument);
        AggregateDiff diffs = new AggregateDiff(expectedDocument, actualDocument, this.settings);
        String expectedEncoding = expectedDocument.getInputEncoding();
        String actualEncoding = actualDocument.getInputEncoding();
        if (!NullSafeComparator.equals((Object)expectedEncoding, (Object)actualEncoding) && this.settings.isEncodingRelevant()) {
            diffs.addDetail(this.diffFactory.different(expectedEncoding, actualEncoding, "document encoding", "/", "/"));
        }
        String expectedRootName = expectedDocument.getDocumentElement().getNodeName();
        String actualRootName = actualDocument.getDocumentElement().getNodeName();
        this.compareElements(expectedDocument.getDocumentElement(), actualDocument.getDocumentElement(), context, "/" + expectedRootName, "/" + actualRootName, diffs);
        return diffs;
    }

    AggregateDiff compareElements(Element expected, Element actual, ComparisonContext context, String parentPathOfExpected, String parentPathOfActual, AggregateDiff diffs) {
        if (context.isExcluded(expected)) {
            return diffs;
        }
        this.compareElementNames(expected, actual, parentPathOfExpected, parentPathOfActual, diffs);
        this.compareAttributes(expected, actual, context, parentPathOfExpected, parentPathOfActual, diffs);
        this.compareChildNodes(expected, actual, context, parentPathOfExpected, parentPathOfActual, diffs);
        return diffs;
    }

    private void compareElementNames(Element expected, Element actual, String parentPathOfExpected, String parentPathOfActual, AggregateDiff diffs) {
        String actualNs;
        String expectedNs;
        String elementName = expected.getLocalName();
        this.expectEqualStrings(elementName, actual.getLocalName(), "element name", parentPathOfExpected, parentPathOfActual, diffs);
        if (this.settings.isNamespaceRelevant() && !NullSafeComparator.equals((Object)(expectedNs = StringUtil.emptyToNull((String)expected.getNamespaceURI())), (Object)(actualNs = StringUtil.emptyToNull((String)actual.getNamespaceURI())))) {
            diffs.addDetail(this.diffFactory.different(XMLComparator.nsDescription(expectedNs), XMLComparator.nsDescription(actualNs), "element namespace", parentPathOfExpected, parentPathOfActual));
        }
    }

    private static String nsDescription(String namespace) {
        return namespace != null ? namespace : "none";
    }

    private void compareAttributes(Element expectedElement, Element actualElement, ComparisonContext context, String parentPathOfExpected, String parentPathOfActual, AggregateDiff diffs) {
        NamedNodeMap expectedAttributes = expectedElement.getAttributes();
        for (int i = 0; i < expectedAttributes.getLength(); ++i) {
            Attr expectedAttribute = (Attr)expectedAttributes.item(i);
            if (XMLComparator.isXmlnsAttribute(expectedAttribute) || context.isExcluded(expectedAttribute)) continue;
            this.expectEqualAttribute(expectedAttribute, actualElement, context, parentPathOfExpected, parentPathOfActual, diffs);
        }
        NamedNodeMap actualAttributes = actualElement.getAttributes();
        for (int i = 0; i < actualAttributes.getLength(); ++i) {
            Attr actualAttribute = (Attr)actualAttributes.item(i);
            Attr expectedAttribute = (Attr)expectedAttributes.getNamedItem(actualAttribute.getNodeName());
            if (expectedAttribute != null || XMLComparator.isXmlnsAttribute(actualAttribute) || context.isTolerated(DiffDetailType.UNEXPECTED, expectedAttribute, actualAttribute)) continue;
            diffs.addDetail(this.diffFactory.unexpected(actualAttribute.getValue(), "attribute value", XMLComparator.attributePath(parentPathOfActual, actualAttribute)));
        }
    }

    private static boolean isXmlnsAttribute(Attr attribute) {
        String name = attribute.getName();
        return "xmlns".equals(name) || name.startsWith("xmlns:");
    }

    private void compareChildNodes(Element expected, Element actual, ComparisonContext context, String parentPathOfExpected, String parentPathOfActual, AggregateDiff diffs) {
        Node[] expectedChildNodes = this.settings.getModel().childNodes(expected);
        Node[] actualChildNodes = this.settings.getModel().childNodes(actual);
        if (expectedChildNodes.length > 0 || actualChildNodes.length > 0) {
            this.compareNodeArrays(expectedChildNodes, actualChildNodes, context, parentPathOfExpected, parentPathOfActual, diffs);
        }
        Iterator<DiffDetail> iterator = diffs.getDetails().iterator();
        while (iterator.hasNext()) {
            DiffDetail diff = iterator.next();
            if (!context.isTolerated(diff.getType(), diff.getExpected(), diff.getActual())) continue;
            iterator.remove();
        }
    }

    private void compareNodeArrays(Node[] expectedNodes, Node[] actualNodes, ComparisonContext context, String parentPathOfExpected, String parentPathOfActual, AggregateDiff diffs) {
        ArrayComparisonResult result = ArrayComparator.compare(expectedNodes, actualNodes, this.settings.getModel(), parentPathOfExpected, parentPathOfActual, this.diffFactory);
        for (DiffDetail diff : result.getDiffs()) {
            if (diff.getType() == DiffDetailType.DIFFERENT && diff.getExpected() instanceof Element && diff.getActual() instanceof Element) {
                this.compareElements((Element)diff.getExpected(), (Element)diff.getActual(), context, String.valueOf(diff.getLocatorOfExpected()), String.valueOf(diff.getLocatorOfActual()), diffs);
                continue;
            }
            if (diff.getType() == DiffDetailType.DIFFERENT && diff.getExpected() instanceof Text && diff.getActual() instanceof Text) {
                this.handleTextDiff(diff, diffs, context);
                continue;
            }
            if (diff.getExpected() instanceof ProcessingInstruction || diff.getActual() instanceof ProcessingInstruction) {
                this.handleProcesingInstructionDiff(diff, diffs, context);
                continue;
            }
            diffs.addDetail(diff);
        }
    }

    private void handleTextDiff(DiffDetail diff, AggregateDiff diffs, ComparisonContext context) {
        String locatorOfActual = StringUtil.removeSuffixIfPresent((String)"/#text", (String)diff.getLocatorOfActual());
        String locatorOfExpected = StringUtil.removeSuffixIfPresent((String)"/#text", (String)diff.getLocatorOfExpected());
        if (!context.isTolerated(DiffDetailType.DIFFERENT, locatorOfActual)) {
            diffs.addDetail(this.diffFactory.different(diff.getExpected(), diff.getActual(), "element text", locatorOfExpected, locatorOfActual));
        }
    }

    private void handleProcesingInstructionDiff(DiffDetail diff, AggregateDiff diffs, ComparisonContext context) {
        ProcessingInstruction expectedPI = (ProcessingInstruction)diff.getExpected();
        ProcessingInstruction actualPI = (ProcessingInstruction)diff.getActual();
        String locatorOfExpected = XMLComparator.procIntLocator(StringUtil.removeSuffixIfPresent((String)"/procint", (String)diff.getLocatorOfExpected()), expectedPI);
        String locatorOfActual = XMLComparator.procIntLocator(StringUtil.removeSuffixIfPresent((String)"/procint", (String)diff.getLocatorOfActual()), actualPI);
        if (!context.isTolerated(diff.getType(), locatorOfExpected) && !context.isTolerated(diff.getType(), locatorOfActual)) {
            diffs.addDetail(this.diffFactory.genericDiff(expectedPI, actualPI, "processing instruction", diff.getType(), locatorOfExpected, locatorOfActual));
        }
    }

    private void expectEqualStrings(String expectedValue, String actualValue, String type, String locatorOfExpected, String locatorOfActual, AggregateDiff diffs) {
        if (!NullSafeComparator.equals((Object)expectedValue, (Object)actualValue)) {
            diffs.addDetail(this.diffFactory.different(expectedValue, actualValue, type, locatorOfExpected, locatorOfActual));
        }
    }

    private void expectEqualAttribute(Attr expectedAttribute, Element actualElement, ComparisonContext context, String parentPathOfExpected, String parentPathOfActual, AggregateDiff diffs) {
        String attributeName = expectedAttribute.getName();
        Attr actualAttribute = actualElement.getAttributeNode(attributeName);
        String expectedAttValue = expectedAttribute.getValue();
        if (actualAttribute == null) {
            if (!context.isTolerated(DiffDetailType.MISSING, expectedAttribute, null)) {
                diffs.addDetail(this.diffFactory.missing(expectedAttValue, "attribute value", XMLComparator.attributePath(parentPathOfExpected, expectedAttribute)));
            }
        } else {
            String actualAttValue = actualAttribute.getValue();
            if (!expectedAttValue.equals(actualAttValue) && !context.isTolerated(DiffDetailType.DIFFERENT, expectedAttribute, actualAttribute)) {
                String locatorOfExpected = XMLComparator.attributePath(parentPathOfExpected, expectedAttribute);
                String locatorOfActual = XMLComparator.attributePath(parentPathOfActual, actualAttribute);
                diffs.addDetail(this.diffFactory.different(expectedAttValue, actualAttValue, "attribute value", locatorOfExpected, locatorOfActual));
            }
        }
    }

    private static String attributePath(String parentPath, Attr attribute) {
        return parentPath + "/@" + attribute.getName();
    }

    private static String procIntLocator(String parentPath, ProcessingInstruction pi) {
        return parentPath != null && pi != null ? parentPath + "/?" + pi.getTarget() : null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.settings + "]";
    }
}

