/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.xml.compare;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.databene.commons.BeanUtil;
import org.databene.commons.IOUtil;
import org.databene.commons.SyntaxError;
import org.databene.commons.xml.SimpleXMLWriter;
import org.databene.commons.xml.XMLUtil;
import org.databene.formats.compare.DiffDetailType;
import org.databene.formats.compare.KeyExpression;
import org.databene.formats.compare.LocalDiffType;
import org.databene.formats.xml.compare.DefaultXMLComparisonModel;
import org.databene.formats.xml.compare.XMLComparisonModel;
import org.databene.formats.xml.compare.XMLComparisonSettings;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLComparisonSettingsSerializer {
    private static final String COMPARISON_SETTINGS = "comparison-settings";
    private static final String MODEL_CLASS = "modelClass";
    private static final String XML_SETTINGS = "xml-settings";
    private static final String CDATA_RELEVANT = "cdataRelevant";
    private static final String COMMENT_RELEVANT = "commentRelevant";
    private static final String ENCODING_RELEVANT = "encodingRelevant";
    private static final String NAMESPACE_RELEVANT = "namespaceRelevant";
    private static final String PROCESSING_INSTRUCTION_RELEVANT = "processingInstructionRelevant";
    private static final String WHITESPACE_RELEVANT = "whitespaceRelevant";
    private static final String TOLERATED_DIFFS = "tolerated-diffs";
    private static final String TOLERATED_DIFF = "tolerated-diff";
    private static final String LOCATOR = "locator";
    private static final String TYPE = "type";
    private static final String KEY_EXPRESSIONS = "key-expressions";
    private static final String KEY_EXPRESSION = "key-expression";
    private static final String DEFINITION = "definition";

    public void save(XMLComparisonSettings settings, OutputStream stream) {
        SimpleXMLWriter writer = null;
        try {
            writer = new SimpleXMLWriter(stream, "UTF-8", true);
            writer.startDocument();
            writer.startElement(COMPARISON_SETTINGS, new String[]{MODEL_CLASS, settings.getModel().getClass().getName()});
            this.saveXmlElementSettings(writer, settings);
            this.saveToleratedDiffs(writer, settings);
            this.saveKeys(writer, settings);
            writer.endElement(COMPARISON_SETTINGS);
            writer.endDocument();
        }
        catch (SAXException e) {
            try {
                throw new RuntimeException("Error saving settings", e);
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
        }
        IOUtil.close((Closeable)writer);
    }

    public XMLComparisonSettings load(InputStream stream) throws IOException {
        Document document = XMLUtil.parse((InputStream)stream);
        Element root = document.getDocumentElement();
        this.assertElementName(COMPARISON_SETTINGS, root);
        XMLComparisonSettings settings = this.loadXmlElementSettings(root);
        this.loadToleratedDiffs(root, settings);
        this.loadKeys(root, settings);
        return settings;
    }

    private void saveXmlElementSettings(SimpleXMLWriter writer, XMLComparisonSettings settings) throws SAXException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put(CDATA_RELEVANT, String.valueOf(settings.isCdataRelevant()));
        attrs.put(COMMENT_RELEVANT, String.valueOf(settings.isCommentRelevant()));
        attrs.put(ENCODING_RELEVANT, String.valueOf(settings.isEncodingRelevant()));
        attrs.put(NAMESPACE_RELEVANT, String.valueOf(settings.isNamespaceRelevant()));
        attrs.put(PROCESSING_INSTRUCTION_RELEVANT, String.valueOf(settings.isProcessingInstructionRelevant()));
        attrs.put(WHITESPACE_RELEVANT, String.valueOf(settings.isWhitespaceRelevant()));
        writer.writeElement(XML_SETTINGS, attrs);
    }

    private void saveToleratedDiffs(SimpleXMLWriter writer, XMLComparisonSettings settings) throws SAXException {
        writer.startElement(TOLERATED_DIFFS, new String[0]);
        for (LocalDiffType toleratedDiff : settings.getToleratedDiffs()) {
            HashMap<String, String> atts = new HashMap<String, String>();
            atts.put(LOCATOR, toleratedDiff.getLocator());
            atts.put(TYPE, toleratedDiff.getType().toString());
            writer.writeElement(TOLERATED_DIFF, atts);
        }
        writer.endElement(TOLERATED_DIFFS);
    }

    private void saveKeys(SimpleXMLWriter writer, XMLComparisonSettings settings) throws SAXException {
        writer.startElement(KEY_EXPRESSIONS, new String[0]);
        for (KeyExpression keyDefinition : settings.getModel().getKeyExpressions()) {
            HashMap<String, String> atts = new HashMap<String, String>();
            atts.put(LOCATOR, keyDefinition.getLocator());
            atts.put(DEFINITION, keyDefinition.getExpression());
            writer.writeElement(KEY_EXPRESSION, atts);
        }
        writer.endElement(KEY_EXPRESSIONS);
    }

    private XMLComparisonSettings loadXmlElementSettings(Element root) {
        Element settingsElement = (Element)root.getElementsByTagName(XML_SETTINGS).item(0);
        String modelClassName = XMLUtil.getAttribute((Element)settingsElement, (String)MODEL_CLASS, (boolean)false);
        if (modelClassName == null) {
            modelClassName = DefaultXMLComparisonModel.class.getName();
        }
        XMLComparisonModel model = (XMLComparisonModel)BeanUtil.newInstance((String)modelClassName);
        XMLComparisonSettings settings = new XMLComparisonSettings(model);
        settings.setCdataRelevant(XMLUtil.getBooleanAttribute((Element)settingsElement, (String)CDATA_RELEVANT, (boolean)true));
        settings.setCommentRelevant(XMLUtil.getBooleanAttribute((Element)settingsElement, (String)COMMENT_RELEVANT, (boolean)true));
        settings.setEncodingRelevant(XMLUtil.getBooleanAttribute((Element)settingsElement, (String)ENCODING_RELEVANT, (boolean)true));
        settings.setNamespaceRelevant(XMLUtil.getBooleanAttribute((Element)settingsElement, (String)NAMESPACE_RELEVANT, (boolean)true));
        settings.setProcessingInstructionRelevant(XMLUtil.getBooleanAttribute((Element)settingsElement, (String)PROCESSING_INSTRUCTION_RELEVANT, (boolean)true));
        settings.setWhitespaceRelevant(XMLUtil.getBooleanAttribute((Element)settingsElement, (String)WHITESPACE_RELEVANT, (boolean)true));
        return settings;
    }

    private void loadToleratedDiffs(Element root, XMLComparisonSettings settings) {
        Element tolerationsRoot = (Element)root.getElementsByTagName(TOLERATED_DIFFS).item(0);
        NodeList tolerationsElements = tolerationsRoot.getElementsByTagName(TOLERATED_DIFF);
        for (int i = 0; i < tolerationsElements.getLength(); ++i) {
            Element element = (Element)tolerationsElements.item(i);
            String locator = XMLUtil.getAttribute((Element)element, (String)LOCATOR, (boolean)true);
            DiffDetailType type = DiffDetailType.valueOf(XMLUtil.getAttribute((Element)element, (String)TYPE, (boolean)true));
            settings.addToleratedDiff(new LocalDiffType(type, locator));
        }
    }

    private void loadKeys(Element root, XMLComparisonSettings settings) {
        Element keysRoot = (Element)root.getElementsByTagName(KEY_EXPRESSIONS).item(0);
        NodeList keyElements = keysRoot.getElementsByTagName(KEY_EXPRESSION);
        for (int i = 0; i < keyElements.getLength(); ++i) {
            Element element = (Element)keyElements.item(i);
            String locator = XMLUtil.getAttribute((Element)element, (String)LOCATOR, (boolean)true);
            String definition = XMLUtil.getAttribute((Element)element, (String)DEFINITION, (boolean)true);
            settings.addKeyExpression(locator, definition);
        }
    }

    private void assertElementName(String name, Element element) {
        if (!name.equals(element.getNodeName())) {
            String message = "Expected element <" + name + ">, but found <" + element.getNodeName() + ">";
            throw new SyntaxError(message, XMLUtil.formatShort((Element)element));
        }
    }
}

