/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.xml.tree;

import org.databene.formats.xml.tree.DocumentSyntaxError;
import org.databene.formats.xml.tree.XMLParsingResult;
import org.databene.formats.xml.tree.XMLToken;
import org.databene.formats.xml.tree.XMLTokenIterator;
import org.databene.formats.xml.tree.XMLTokenType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLParser.class);

    public XMLParsingResult parse(XMLTokenIterator iterator) {
        XMLParsingResult result = new XMLParsingResult();
        if (iterator.peekNext() == null) {
            this.syntaxError("Empty text", 0, 0, result);
            return result;
        }
        boolean contentOccurred = false;
        while (iterator.peekNextType() != XMLTokenType.DECLARATION && iterator.peekNextType() != XMLTokenType.TAG_START && iterator.peekNextType() != null) {
            contentOccurred = true;
            iterator.next();
        }
        if (iterator.peekNextType() == XMLTokenType.DECLARATION && contentOccurred) {
            this.syntaxError("No content allowed before prolog", 0, ((XMLToken)iterator.current()).getEndOffset(), result);
        }
        this.skipWhitespace(iterator);
        this.assertNextType(XMLTokenType.TAG_START, iterator, result);
        return result;
    }

    private void assertNextType(XMLTokenType expectedType, XMLTokenIterator iterator, XMLParsingResult result) {
        XMLToken token = (XMLToken)iterator.peekNext();
        if (expectedType != token.getType()) {
            this.syntaxError((Object)((Object)expectedType) + " expected", token.getStartOffset(), token.getEndOffset(), result);
        }
    }

    private void skipWhitespace(XMLTokenIterator iterator) {
    }

    private void syntaxError(String message, int startOffset, int endOffset, XMLParsingResult result) {
        LOGGER.debug("{} from {} to {}", new Object[]{message, startOffset, endOffset});
        result.addSyntaxError(new DocumentSyntaxError(message, startOffset, endOffset));
    }
}

