/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.xsd;

import java.util.Collection;
import java.util.Map;
import org.databene.commons.Visitor;
import org.databene.commons.collection.OrderedNameMap;
import org.databene.formats.xsd.Attribute;
import org.databene.formats.xsd.ComplexMember;
import org.databene.formats.xsd.ComplexType;
import org.databene.formats.xsd.SchemaElement;

public class CompositeComplexType
extends ComplexType {
    private Map<String, ComplexMember> members = new OrderedNameMap();

    public CompositeComplexType(String name) {
        super(name);
    }

    public void addMember(ComplexMember member) {
        this.members.put(member.getName(), member);
    }

    public Collection<ComplexMember> getMembers() {
        return this.members.values();
    }

    @Override
    public void printContent(String indent) {
        System.out.println(indent + super.toString());
        indent = indent + "  ";
        for (Attribute attribute : this.attributes.values()) {
            attribute.printContent(indent);
        }
        for (ComplexMember member : this.members.values()) {
            member.printContent(indent);
        }
    }

    @Override
    public void accept(Visitor<SchemaElement> visitor) {
        super.accept(visitor);
        for (ComplexMember type : this.members.values()) {
            type.accept(visitor);
        }
    }
}

