/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.xsd;

import java.util.Map;
import org.databene.commons.Named;
import org.databene.commons.Visitor;
import org.databene.commons.collection.OrderedNameMap;
import org.databene.formats.xsd.ComplexMember;
import org.databene.formats.xsd.ComplexType;
import org.databene.formats.xsd.SchemaElement;
import org.databene.formats.xsd.SimpleType;

public class Schema
extends SchemaElement
implements Named {
    private Map<String, SimpleType> simpleTypes = new OrderedNameMap();
    private Map<String, ComplexType> complexTypes = new OrderedNameMap();
    private ComplexMember member;

    public String getName() {
        return this.member != null ? this.member.getName() : null;
    }

    public void addSimpleType(SimpleType simpleType) {
        this.simpleTypes.put(simpleType.getName(), simpleType);
    }

    public void addComplexType(ComplexType complexType) {
        this.complexTypes.put(complexType.getName(), complexType);
    }

    public ComplexType getComplexType(String name) {
        return this.complexTypes.get(name);
    }

    public ComplexMember getMember() {
        return this.member;
    }

    public void setMember(ComplexMember member) {
        this.member = member;
    }

    public void printContent() {
        System.out.println("Schema" + this.renderShortDocumentation());
        for (SimpleType simpleType : this.simpleTypes.values()) {
            simpleType.printContent("  ");
        }
        for (ComplexType complexType : this.complexTypes.values()) {
            complexType.printContent("  ");
        }
        this.member.printContent("  ");
    }

    @Override
    public void accept(Visitor<SchemaElement> visitor) {
        super.accept(visitor);
        for (SimpleType simpleType : this.simpleTypes.values()) {
            simpleType.accept(visitor);
        }
        for (ComplexType complexType : this.complexTypes.values()) {
            complexType.accept(visitor);
        }
        this.member.accept(visitor);
    }
}

