/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.xsd;

import org.databene.commons.StringUtil;
import org.databene.commons.xml.XMLUtil;
import org.databene.formats.xsd.Attribute;
import org.databene.formats.xsd.ComplexMember;
import org.databene.formats.xsd.ComplexType;
import org.databene.formats.xsd.CompositeComplexType;
import org.databene.formats.xsd.PlainComplexType;
import org.databene.formats.xsd.Schema;
import org.databene.formats.xsd.SimpleType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SchemaParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaParser.class);

    public Schema parse(Document document) {
        Element root = document.getDocumentElement();
        return this.parseSchema(root);
    }

    private Schema parseSchema(Element root) {
        Schema schema = new Schema();
        for (Element child : XMLUtil.getChildElements((Element)root)) {
            String childName = child.getLocalName();
            if ("annotation".equals(childName)) {
                schema.setDocumentation(SchemaParser.parseAnnotationDocumentation(child));
                continue;
            }
            if ("simpleType".equals(childName)) {
                schema.addSimpleType(SchemaParser.parseSimpleType(child));
                continue;
            }
            if ("complexType".equals(childName)) {
                schema.addComplexType(this.parseComplexType(child, schema));
                continue;
            }
            if ("element".equals(childName)) {
                schema.setMember(this.parseElement(child, schema));
                continue;
            }
            throw new UnsupportedOperationException("Not a supported child of 'schema': " + childName);
        }
        return schema;
    }

    private static String parseAnnotationDocumentation(Element element) {
        for (Element child : XMLUtil.getChildElements((Element)element)) {
            String childName = child.getLocalName();
            if (!"documentation".equals(childName)) continue;
            return child.getTextContent();
        }
        return null;
    }

    private static SimpleType parseSimpleType(Element element) {
        SimpleType simpleType = new SimpleType(element.getAttribute("name"));
        return simpleType;
    }

    private ComplexType parseComplexType(Element element, Schema schema) {
        Element simpleContent = XMLUtil.getChildElement((Element)element, (boolean)false, (boolean)false, (String)"simpleContent");
        if (simpleContent != null) {
            return SchemaParser.parseComplexTypeWithSimpleContent(element);
        }
        Element sequence = XMLUtil.getChildElement((Element)element, (boolean)false, (boolean)false, (String)"sequence");
        if (sequence != null) {
            return this.parseComplexTypeWithSequence(element, schema);
        }
        throw new UnsupportedOperationException("Not a supported kind of 'complexType': " + element.getAttribute("name"));
    }

    private static ComplexType parseComplexTypeWithSimpleContent(Element element) {
        String name = XMLUtil.getAttribute((Element)element, (String)"name", (boolean)false);
        PlainComplexType type = new PlainComplexType(name);
        for (Element child : XMLUtil.getChildElements((Element)element)) {
            String childName = child.getLocalName();
            if ("simpleContent".equals(childName)) {
                SchemaParser.parseSimpleContent(child, type);
                continue;
            }
            if ("attribute".equals(childName)) {
                type.addAttribute(SchemaParser.parseAttribute(child));
                continue;
            }
            throw new UnsupportedOperationException("Not a supported child of '" + element.getNodeName() + "': " + childName);
        }
        return type;
    }

    private static void parseSimpleContent(Element element, PlainComplexType type) {
        for (Element child : XMLUtil.getChildElements((Element)element)) {
            String childName = child.getLocalName();
            if ("restriction".equals(childName)) {
                SchemaParser.parseRestriction(child, type);
                continue;
            }
            LOGGER.warn("Not a supported child of '" + element.getNodeName() + "': " + childName);
        }
    }

    private static void parseRestriction(Element element, PlainComplexType type) {
        for (Element child : XMLUtil.getChildElements((Element)element)) {
            String childName = child.getLocalName();
            if ("minLength".equals(childName)) {
                type.setMinLength(XMLUtil.getIntegerAttribute((Element)child, (String)"value", null));
                continue;
            }
            if (!"maxLength".equals(childName)) continue;
            type.setMaxLength(XMLUtil.getIntegerAttribute((Element)child, (String)"value", null));
        }
    }

    private ComplexType parseComplexTypeWithSequence(Element element, Schema schema) {
        String name = XMLUtil.getAttribute((Element)element, (String)"name", (boolean)false);
        CompositeComplexType type = new CompositeComplexType(name);
        for (Element child : XMLUtil.getChildElements((Element)element)) {
            String childName = child.getLocalName();
            if ("sequence".equals(childName)) {
                this.parseSequence(child, type, schema);
                continue;
            }
            if ("attribute".equals(childName)) {
                type.addAttribute(SchemaParser.parseAttribute(child));
                continue;
            }
            throw new UnsupportedOperationException("Not a supported child of '" + element.getNodeName() + "': " + childName);
        }
        return type;
    }

    private void parseSequence(Element element, CompositeComplexType complexType, Schema schema) {
        for (Element child : XMLUtil.getChildElements((Element)element)) {
            String childName = child.getLocalName();
            if (!"element".equals(childName)) {
                throw new UnsupportedOperationException("Not a supported child of 'element': " + childName);
            }
            complexType.addMember(this.parseElement(child, schema));
        }
    }

    private static Attribute parseAttribute(Element child) {
        String name = XMLUtil.getAttribute((Element)child, (String)"name", (boolean)true);
        return new Attribute(name);
    }

    private ComplexMember parseElement(Element element, Schema schema) {
        String name = element.getAttribute("name");
        ComplexMember member = new ComplexMember(name, null);
        ComplexType type = null;
        for (Element child : XMLUtil.getChildElements((Element)element)) {
            String childName = child.getLocalName();
            if ("complexType".equals(childName)) {
                type = this.parseComplexType(child, schema);
                continue;
            }
            if ("annotation".equals(childName)) {
                member.setDocumentation(SchemaParser.parseAnnotationDocumentation(child));
                continue;
            }
            throw new UnsupportedOperationException("Not a supported child of 'element': " + childName);
        }
        if (type == null) {
            String typeName = XMLUtil.getAttribute((Element)element, (String)"type", (boolean)true);
            type = schema.getComplexType(typeName);
        }
        member.setType(type);
        member.setMinCardinality(SchemaParser.parseOccursAttribute(element, "minOccurs"));
        member.setMaxCardinality(SchemaParser.parseOccursAttribute(element, "maxOccurs"));
        return member;
    }

    private static int parseOccursAttribute(Element element, String name) {
        String stringValue = element.getAttribute(name);
        if (StringUtil.isEmpty((CharSequence)stringValue)) {
            return 1;
        }
        if ("unbounded".equals(stringValue)) {
            return -1;
        }
        return Integer.parseInt(stringValue);
    }
}

