/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.xslt;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XSLTTransformer {
    private static final Map<String, Transformer> transformers = new HashMap<String, Transformer>();

    private static Transformer getTransformer(String xsltString) throws TransformerConfigurationException {
        Transformer transformer = transformers.get(xsltString);
        if (transformer == null) {
            StreamSource xsltSource = new StreamSource(new StringReader(xsltString));
            transformer = TransformerFactory.newInstance().newTransformer(xsltSource);
            transformers.put(xsltString, transformer);
        }
        return transformer;
    }

    public static String transform(String xmlString, String xsltString) throws TransformerException {
        StringReader source = new StringReader(xmlString);
        StringWriter writer = new StringWriter();
        XSLTTransformer.transform(source, xsltString, writer);
        return writer.getBuffer().toString();
    }

    public static void transform(Reader reader, String xsltString, Writer writer) throws TransformerException {
        Transformer transformer = XSLTTransformer.getTransformer(xsltString);
        transformer.transform(new StreamSource(reader), new StreamResult(writer));
    }
}

