/*
 * (c) Copyright 2008 by Volker Bergmann. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, is permitted under the terms of the
 * GNU General Public License.
 *
 * For redistributing this software or a derivative work under a license other
 * than the GPL-compatible Free Software License as defined by the Free
 * Software Foundation or approved by OSI, you must first obtain a commercial
 * license to this software product from Volker Bergmann.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * WITHOUT A WARRANTY OF ANY KIND. ALL EXPRESS OR IMPLIED CONDITIONS,
 * REPRESENTATIONS AND WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE
 * HEREBY EXCLUDED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

package org.databene.gui.swing;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import javax.swing.AbstractListModel;

/**
 * Component that allows for defining an ordered list of files.<br/>
 * <br/>
 * Created at 30.11.2008 15:11:05
 * @since 0.1.6
 * @author Volker Bergmann
 */

public class ArrayListModel extends AbstractListModel {
	
	private static final long serialVersionUID = 3499248476952363886L;
	private ArrayList<File> elements = new ArrayList<File>();

	public Object getElementAt(int index) {
		return elements.get(index);
	}

	public int getSize() {
		return elements.size();
	}
	
	public List<File> getAll() {
		return elements;
	}

	public void add(File file) {
		elements.add(file);
		fireIntervalAdded(this, elements.size() - 1, elements.size() - 1);
	}

	public void set(int index, File file) {
		elements.set(index, file);
		fireContentsChanged(this, index, index);
	}

	public void remove(int index) {
		elements.remove(index);
		fireIntervalRemoved(this, index, index);
	}

	public void setAll(File ... files) {
		this.elements.clear();
		for (File file : files)
			this.elements.add(file);
	}

}
