/*
 * Decompiled with CFR 0.152.
 */
package org.databene.gui.awt;

import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import org.databene.commons.SystemInfo;
import org.databene.commons.ui.FileChooser;
import org.databene.commons.ui.FileOperation;
import org.databene.commons.ui.FileTypeSupport;

public class AwtFileChooser
extends FileDialog
implements FileChooser {
    private static final long serialVersionUID = -3217299586317875276L;
    FileTypeSupport supportedTypes;

    public AwtFileChooser(String prompt, FileOperation operation, FileTypeSupport supportedTypes) {
        super((Frame)null, prompt, operation == FileOperation.open ? 0 : 1);
        this.supportedTypes = supportedTypes;
    }

    public File chooseFile(Component owner) {
        if (this.supportedTypes == FileTypeSupport.directoriesOnly) {
            System.setProperty("apple.awt.fileDialogForDirectories", "true");
        }
        this.setVisible(true);
        System.setProperty("apple.awt.fileDialogForDirectories", "false");
        return this.getSelectedFile();
    }

    public void setCurrentDirectory(File currentDirectory) {
        if (currentDirectory == null) {
            currentDirectory = new File(SystemInfo.getCurrentDir());
        }
        this.setDirectory(currentDirectory.getAbsolutePath());
    }

    public void setSelectedFile(File file) {
        this.setDirectory(file.getParent());
        this.setFile(file.getName());
    }

    public File getSelectedFile() {
        if (this.getFile() == null) {
            return null;
        }
        if (this.supportedTypes == FileTypeSupport.directoriesOnly) {
            return new File(this.getDirectory());
        }
        return new File(this.getDirectory(), this.getFile());
    }
}

