/*
 * Decompiled with CFR 0.152.
 */
package org.databene.gui.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JTextField;
import org.databene.commons.SystemInfo;
import org.databene.commons.file.FilenameFormat;
import org.databene.commons.ui.FileChooser;
import org.databene.commons.ui.FileOperation;
import org.databene.commons.ui.FileTypeSupport;
import org.databene.gui.awt.AwtFileChooser;
import org.databene.gui.swing.SwingFileChooser;

public class FileField
extends Box {
    private static final long serialVersionUID = 2088339867450647264L;
    boolean fullPathDisplayed;
    private FilenameFormat filenameFormat;
    JTextField filenameField;
    FileChooser chooser;
    private List<ActionListener> actionListeners;
    FileOperation operation;
    String approveButtonText;

    public FileField() {
        this(20);
    }

    public FileField(int columns) {
        this(columns, null, FileTypeSupport.filesOnly, FileOperation.open);
    }

    public FileField(int columns, File file, FileTypeSupport fileTypeSupport, String approveButtonText) {
        this(columns, file, fileTypeSupport, (FileOperation)null);
    }

    public FileField(int columns, File file, FileTypeSupport supportedTypes, FileOperation operation) {
        super(0);
        this.setBorder(null);
        this.fullPathDisplayed = true;
        this.operation = operation;
        this.filenameField = new JTextField(columns);
        this.chooser = SystemInfo.isMacOsx() ? new AwtFileChooser(null, operation, supportedTypes) : new SwingFileChooser(supportedTypes, operation);
        if (file != null && file.exists()) {
            this.chooser.setSelectedFile(file);
            this.filenameField.setText(file.getAbsolutePath());
        }
        this.filenameField.setEditable(false);
        this.add((Component)this.filenameField, "Center");
        JButton button = new JButton("...");
        this.add((Component)button, "East");
        button.addActionListener(new Listener());
        this.filenameFormat = new FilenameFormat(true);
        this.actionListeners = new ArrayList<ActionListener>();
    }

    public File getFile() {
        return this.chooser.getSelectedFile();
    }

    public void setFile(File file) {
        this.chooser.setSelectedFile(file);
        this.filenameField.setText(file.getAbsolutePath());
    }

    public boolean isFullPathUsed() {
        return this.filenameFormat.isFullPathUsed();
    }

    public void setFullPathUsed(boolean fullPathUsed) {
        this.filenameFormat.setFullPathUsed(fullPathUsed);
    }

    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.actionListeners.remove(listener);
    }

    void fireAction(String command) {
        ActionEvent e = new ActionEvent(this, 0, command);
        for (int i = this.actionListeners.size() - 1; i >= 0; --i) {
            this.actionListeners.get(i).actionPerformed(e);
        }
    }

    class Listener
    implements ActionListener {
        Listener() {
        }

        public void actionPerformed(ActionEvent e) {
            File selectedFile;
            File file = null;
            String path = FileField.this.filenameField.getText();
            if (path.length() > 0 && !(file = new File(path)).exists()) {
                file = null;
            }
            if (file != null) {
                FileField.this.chooser.setCurrentDirectory(file.getParentFile());
                FileField.this.chooser.setSelectedFile(file);
            }
            if ((selectedFile = FileField.this.chooser.chooseFile((Component)FileField.this)) != null) {
                FileField.this.filenameField.setText(selectedFile.getAbsolutePath());
                FileField.this.fireAction("files");
            }
        }
    }
}

